<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://www.osivia.org/jsp/taglib/osivia-portal" prefix="op"%>


<portlet:defineObjects />

<!-- Datepicker language -->
<c:set var="datepickerLanguage" value="${fn:toLowerCase(pageContext.response.locale.language)}" />
<c:if test="${'en' ne datepickerLanguage}">
    <script type="text/javascript" src="/osivia-portal-custom-web-assets/components/jquery-ui/i18n/datepicker-${datepickerLanguage}.js"></script>
</c:if>

<portlet:resourceURL id="groupSearch" var="groupSearchUrl" ></portlet:resourceURL>

<portlet:resourceURL id="fieldSearch" var="fieldSearchUrl" ></portlet:resourceURL>

<c:if test="${!form.advancedMode}">
    <portlet:resourceURL id="stepSearch" var="stepSearchUrl" ></portlet:resourceURL>
</c:if>

<portlet:actionURL name="editStep" var="editStepUrl">
</portlet:actionURL>

<div class="content-navbar">
    <!-- Breadcrumb -->
    <div class="content-navbar-breadcrumb">
        <div id="breadcrumb">
        	<div class="">
				<nav>
				    <ol class="breadcrumb hidden-xs">
			            <li>
				            <portlet:actionURL name="editStep" var="cancelStepUrl">
				            	<portlet:param name="cancelStep" value="toProc"/>
							</portlet:actionURL>
							<a href="${cancelStepUrl}"><op:translate key="EDIT_PROCEDURE" /></a>
			            </li>
			            <li><a><op:translate key="EDIT_STEP" /></a></li>
				    </ol>
				</nav>
			</div>
		</div>
    </div>
</div>


<form:form modelAttribute="form" action="${editStepUrl}" method="post" cssClass="form-horizontal" role="form">

    <div class="form-group">
        <div class="col-sm-12">
            <div class="btn-group pull-right">
                <c:if test="${!form.advancedMode}">
                    <button type="submit" class="btn btn-default" name="changeMode"><op:translate key="ADVANCED_MODE" /></button>
                    <button type="submit" class="btn btn-info active" name="changeMode"><op:translate key="SIMPLE_MODE" /></button>
                </c:if>
                <c:if test="${form.advancedMode}">
                    <button type="submit" class="btn btn-info active" name="changeMode"><op:translate key="ADVANCED_MODE" /></button>
                    <button type="submit" class="btn btn-default" name="changeMode"><op:translate key="SIMPLE_MODE" /></button>
                </c:if>
            </div>
        </div>
    </div>
    
    <ul class="nav nav-tabs" role="tablist">
        <li role="presentation" class="<c:if test="${empty activeTab or ('form' ne activeTab && 'action' ne activeTab)}">active</c:if>"><a href="#Identification" role="tab" data-toggle="tab" class="no-ajax-link"><op:translate key="ID" /></a></li>
        <li role="presentation" class="<c:if test="${'form' eq activeTab}">active</c:if>"><a href="#Formulaire" role="tab" data-toggle="tab" class="no-ajax-link"><op:translate key="FORM" /></a></li>
        <li role="presentation" class="<c:if test="${'action' eq activeTab}">active</c:if>"><a href="#Actions" role="tab" data-toggle="tab" class="no-ajax-link"><op:translate key="ACTIONS" /></a></li>
        <li role="presentation"><a href="#Mtadonnes" role="tab" data-toggle="tab" class="no-ajax-link"><op:translate key="METADATA" /></a></li>
    </ul>

    <div class="tab-content">
	    <div role="tabpanel" class="tab-pane <c:if test="${empty activeTab or ('form' ne activeTab && 'action' ne activeTab)}">active</c:if>" id="Identification">
	       <div class="form-group">
               <form:label path="theSelectedStep.stepName" cssClass="col-sm-2 control-label"><op:translate key="STEP_TITLE" /></form:label>
               <div class="col-sm-10">
                   <form:input path="theSelectedStep.stepName" type="text" cssClass="form-control" />
               </div>
           </div>
           <div class="form-group">
               <form:label path="theSelectedStep.reference" cssClass="col-sm-2 control-label"><op:translate key="STEP_REFERENCE" /></form:label>
               <div class="col-sm-10">
                   <form:input path="theSelectedStep.reference" type="text" cssClass="form-control" />
               </div>
           </div>
	    </div>
	    <div role="tabpanel" class="tab-pane <c:if test="${'form' eq activeTab}">active</c:if>" id="Formulaire">
	       <div class="row">
	           <div class="col-sm-4">
                   <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="<c:if test="${empty activeFormTab or 'edit' ne activeFormTab}">active</c:if>"><a href="#CreateField" role="tab" data-toggle="tab" class="no-ajax-link"><op:translate key="ADD_FIELD" /></a></li>
                        <li role="presentation"><a href="#CreateFieldset" role="tab" data-toggle="tab" class="no-ajax-link"><op:translate key="ADD_FIELDSET" /></a></li>
		                <c:if test="${not empty form.selectedField}">
		                    <li role="presentation" class="<c:if test="${'edit' eq activeFormTab}">active</c:if>"><a href="#Edit" role="tab" data-toggle="tab" class="no-ajax-link"><op:translate key="EDIT" /></a></li>
		                </c:if>
                   </ul>
                   <div class="tab-content">
                        <div role="tabpanel" class="tab-pane <c:if test="${empty activeFormTab or 'edit' ne activeFormTab}">active</c:if>" id="CreateField">
                            <div class="form-group">
	                            <form:label path="newField.variableName" cssClass="col-sm-3 control-label"><op:translate key="NAME" /></form:label>
	                            <div class="col-sm-9">
	                                <form:select path="newField.variableName" class="fieldSelect-select2 form-control select2" cssStyle="width: 100%;" data-url="${fieldSearchUrl}" data-autofill="true">
                                    </form:select>
                                    <span class="help-block"><op:translate key="NAME_HELP" /></span>
	                            </div>
	                        </div>
	                        <div class="form-group">
	                            <form:label path="newField.label" cssClass="col-sm-3 control-label"><op:translate key="LABEL" /></form:label>
	                            <div class="col-sm-9">
	                                <input name="newField.label" class="form-control" placeholder='<op:translate key="LABEL" />' value="${form.newField.label}" type="text">
	                                <span class="help-block"><op:translate key="LABEL_HELP" /></span>
	                            </div>
	                        </div>
	                        <div class="form-group">
	                            <form:label path="newField.helpText" cssClass="col-sm-3 control-label"><op:translate key="HELP_MSG" /></form:label>
	                            <div class="col-sm-9">
	                                <input name="newField.helpText" class="form-control" placeholder='<op:translate key="HELP_MSG" />' value="${form.newField.helpText}" type="text">
	                                <span class="help-block"><op:translate key="HELP_MSG_HELP" /></span>
	                            </div>
	                        </div>
	                        <div class="form-group">
	                            <form:label path="newField.type" cssClass="col-sm-3 control-label"><op:translate key="TYPE" /></form:label>
	                            <div class="col-sm-9">
	                                <form:select path="newField.type" cssClass="form-control">
	                                    <c:forEach items="${form.variableTypesEnum}" var="variableType">
                                           <form:option value="${variableType}"><op:translate key="${variableType}" /></form:option>
                                         </c:forEach>
	                                </form:select>
	                            </div>
	                        </div>
	                        <div class="form-group hidden">
	                            <form:label path="newField.varOptions" cssClass="col-sm-3 control-label"><op:translate key="OPTIONS" /></form:label>
	                            <div class="col-sm-9">
	                                <input name="newField.varOptions" class="form-control" placeholder='<op:translate key="OPTIONS" />' value="${form.newField.varOptions}" type="text">
	                            </div>
	                        </div>
	                        <div class="form-group hidden" id="formulaire-newField-list-editor">
	                        	<label class="col-sm-3 control-label"><op:translate key="EDIT_OPTIONS" /></label>
		                        <div class="col-sm-9">
		                        	<div class="form-group">
	                        			<label for="formulaire-newField-list-editor-newOption-label" class="col-sm-3 control-label"><op:translate key="LABEL" /></label>
		                        		<div class="col-sm-9">
											<input type="text" class="form-control" id="formulaire-newField-list-editor-newOption-label" placeholder='<op:translate key="LABEL" />'>
		                        		</div>
		                        	</div>
		                        	<div class="form-group">
	                        			<label for="formulaire-newField-list-editor-newOption-value" class="col-sm-3 control-label"><op:translate key="VALUE" /></label>
		                        		<div class="col-sm-9">
											<input type="text" class="form-control" id="formulaire-newField-list-editor-newOption-value" placeholder='<op:translate key="VALUE" />'>
		                        		</div>
		                        	</div>
		                        	<div class="form-group">
		                        		<div class="col-sm-12">
		                        			<button id="formulaire-newField-list-editor-addOption" class="btn btn-default pull-right" type="button"><op:translate key="ADD_OPTION" /></button>
		                        		</div>
		                        	</div>
		                        	<div id="formulaire-newField-list-editor-optionList" class="form-group">
			                        	<table class="table table-condensed">
			                        		<thead>
			                        			<tr>
			                        				<th><op:translate key="LABEL" /></th>
			                        				<th><op:translate key="VALUE" /></th>
			                        				<th></th>
			                        			</tr>
			                        		</thead>
			                        		<tbody>
			                        		
			                        		</tbody>
			                        	</table>
		                        	</div>
		                        </div>
	                        </div>
	                        <div class="form-group">
	                           <div class="col-sm-offset-3 col-sm-9">
	                               <div class="checkbox">
	                                    <label>
	                                       <form:checkbox path="newField.input"/><span><op:translate key="IS_INPUT" /></span>
	                                    </label>
	                                </div>
	                            </div>
	                            <div class="col-sm-offset-3 col-sm-9">
                                   <div class="checkbox">
                                        <label>
                                            <form:checkbox path="newField.required"/><span><op:translate key="REQUIRED" /></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        
                            <button type="submit" name="addField" class="btn btn-default pull-right"><op:translate key="ADD" /></button>
                        
                        </div>
                        <div role="tabpanel" class="tab-pane" id="CreateFieldset">
                            <div class="form-group">
                                <form:label path="newFieldSet.variableName" cssClass="col-sm-3 control-label"><op:translate key="NAME" /></form:label>
                                <div class="col-sm-9">
                                    <input name="newFieldSet.variableName" class="form-control" placeholder='<op:translate key="NAME" />' value="${form.newFieldSet.variableName}" type="text">
                                </div>
                            </div>
                            <div class="form-group">
                                <form:label path="newFieldSet.label" cssClass="col-sm-3 control-label"><op:translate key="LABEL" /></form:label>
                                <div class="col-sm-9">
                                    <input name="newFieldSet.label" class="form-control" placeholder='<op:translate key="LABEL" />' value="${form.newFieldSet.label}" type="text">
                                </div>
                            </div>
                            <button type="submit" name="addFieldSet" class="btn btn-default pull-right"><op:translate key="ADD" /></button>
                        
                        </div>
                        <c:if test="${not empty form.selectedField}">
                            <div role="tabpanel" class="tab-pane <c:if test="${'edit' eq activeFormTab}">active</c:if>" id="Edit">
                                <c:if test="${form.selectedField.fieldSet eq true}">
                                    <div class="form-group">
                                      <form:label path="selectedField.name" cssClass="col-sm-3 control-label"><op:translate key="NAME" /></form:label>
                                      <div class="col-sm-9">
                                      		<p class="form-control-static">${form.selectedField.name}</p>
                                      </div>
                                     </div>
                                    <div class="form-group">
		                                  <form:label path="selectedField.label" cssClass="col-sm-3 control-label"><op:translate key="LABEL" /></form:label>
		                                  <div class="col-sm-9">
		                                      <input name="selectedField.label" class="form-control" placeholder='<op:translate key="LABEL" />' value="${form.selectedField.label}" type="text">
		                                      <span class="help-block"><op:translate key="LABEL_HELP" /></span>
		                                  </div>
		                             </div>
                                </c:if>
                                <c:if test="${form.selectedField.fieldSet ne true}">
	                               <div class="form-group">
				                      <form:label path="selectedField.name" cssClass="col-sm-3 control-label"><op:translate key="NAME" /></form:label>
				                      <div class="col-sm-9">
				                          <p class="form-control-static">${form.selectedField.name}</p>
				                      </div>
			                         </div>
			                        <div class="form-group">
					                      <form:label path="selectedField.superLabel" cssClass="col-sm-3 control-label"><op:translate key="LABEL" /></form:label>
					                      <div class="col-sm-9">
					                          <input name="selectedField.superLabel" class="form-control" placeholder='<op:translate key="LABEL" />' value="${form.selectedField.superLabel}" type="text">
					                          <span class="help-block"><op:translate key="LABEL_HELP" /></span>
					                      </div>
				                     </div>
				                     <div class="form-group">
			                            <form:label path="selectedField.helpText" cssClass="col-sm-3 control-label"><op:translate key="HELP_MSG" /></form:label>
			                            <div class="col-sm-9">
			                                <input name="selectedField.helpText" class="form-control" placeholder='<op:translate key="HELP_MSG" />' value="${form.selectedField.helpText}" type="text">
			                                <span class="help-block"><op:translate key="HELP_MSG_HELP" /></span>
			                            </div>
			                        </div>
				                     <div class="form-group">
					                      <form:label path="selectedField.type" cssClass="col-sm-3 control-label"><op:translate key="TYPE" /></form:label>
					                      <div class="col-sm-9">
					                      		<p class="form-control-static">${form.selectedField.type}</p>
					                      </div>
				                     </div>
				                     <div class="form-group hidden">
					                      <form:label path="selectedField.varOptions" cssClass="col-sm-3 control-label"><op:translate key="OPTIONS" /></form:label>
					                      <div class="col-sm-9">
					                        <input name="selectedField.varOptions" class="form-control" placeholder='<op:translate key="OPTIONS" />' value="${form.selectedField.varOptions}" type="text">
					                      </div>
					                  </div>
					                  
					                  <div class="form-group hidden" id="formulaire-selectedField-list-editor">
			                        	<label class="col-sm-3 control-label"><op:translate key="EDIT_OPTIONS" /></label>
				                        <div class="col-sm-9">
				                        	<div class="form-group">
			                        			<label for="formulaire-selectedField-list-editor-newOption-label" class="col-sm-3 control-label"><op:translate key="LABEL" /></label>
				                        		<div class="col-sm-9">
													<input type="text" class="form-control" id="formulaire-selectedField-list-editor-newOption-label" placeholder='<op:translate key="LABEL" />'>
				                        		</div>
				                        	</div>
				                        	<div class="form-group">
			                        			<label for="formulaire-selectedField-list-editor-newOption-value" class="col-sm-3 control-label"><op:translate key="VALUE" /></label>
				                        		<div class="col-sm-9">
													<input type="text" class="form-control" id="formulaire-selectedField-list-editor-newOption-value" placeholder='<op:translate key="VALUE" />'>
				                        		</div>
				                        	</div>
				                        	<div class="form-group">
				                        		<div class="col-sm-12">
				                        			<button id="formulaire-selectedField-list-editor-addOption" class="btn btn-default pull-right" type="button"><op:translate key="ADD_OPTION" /></button>
				                        		</div>
				                        	</div>
				                        	<div id="formulaire-selectedField-list-editor-optionList" class="form-group">
					                        	<table class="table table-condensed">
					                        		<thead>
					                        			<tr>
					                        				<th><op:translate key="LABEL" /></th>
					                        				<th><op:translate key="VALUE" /></th>
					                        				<th></th>
					                        			</tr>
					                        		</thead>
					                        		<tbody>
					                        		
					                        		</tbody>
					                        	</table>
				                        	</div>
				                        </div>
			                        </div>
                                      <div class="form-group">
			                               <div class="col-sm-offset-3 col-sm-9">
			                                   <div class="checkbox">
			                                        <label>
			                                             <form:checkbox path="selectedField.input"/><span><op:translate key="IS_INPUT" /></span>
			                                        </label>
			                                    </div>
			                                </div>
			                                <div class="col-sm-offset-3 col-sm-9">
			                                   <div class="checkbox">
			                                        <label>
			                                             <form:checkbox path="selectedField.required"/><span><op:translate key="REQUIRED" /></span>
			                                        </label>
			                                    </div>
			                                </div>
			                            </div>
                                </c:if>
			                  <div class="pull-right">
	                               <button type="submit" name="editField" class="btn btn-default"><op:translate key="MODIFY" /></button>
	                               <button type="submit" name="deleteField" class="btn btn-default">
	                                    <i class="glyphicons glyphicons-bin"></i>
	                                </button>
		                       </div>
                            </div>
                        </c:if>
                   
                   </div>
	           </div>
	           
		       <div id="procedure-sortable" class="col-sm-8">
	               <ul class="procedure-sortable list-unstyled">
	                   <c:forEach var="field" items="${form.theSelectedStep.fields}" varStatus="status">
                          <c:choose>
                            <c:when test="${field.fieldSet eq true}">
                              <c:set var="field" value="${field}" scope="request"/>
                              <jsp:include page="editFields.jsp"/>
                            </c:when>
                            <c:otherwise>
                              <c:set var="field" value="${field}" scope="request"/>
                              <jsp:include page="editField.jsp"/>
                            </c:otherwise>
                          </c:choose>
	                   </c:forEach>
	                   <form:input path="selectedStep" type="hidden" name="selectedStep"/>
	               </ul>
	           </div>
            </div>
	    </div>
	    <div role="tabpanel" class="tab-pane <c:if test="${'action' eq activeTab}">active</c:if>" id="Actions">
	    
       <ul class="list-unstyled">
             <li class="form-group">
                <div class="col-sm-2">
                    <label class="control-label"><op:translate key="LABEL" /></label>
                </div>
                <div class="col-sm-4">
                    <label class="control-label"><op:translate key="ACTION_ID" /></label>
                </div>
                <div class="col-sm-4">
                    <label class="control-label"><op:translate key="ACTION_TARGET_REF" /></label>
                </div>
             </li>
              <c:forEach var="action" items="${form.theSelectedStep.actions}" varStatus="status">
                  <li class="form-group">
                      <div class="col-sm-2">
                          <input name="theSelectedStep.actions[${status.index}].label" class="form-control" placeholder='<op:translate key="LABEL" />' value="${form.theSelectedStep.actions[status.index].label}" type="text">
                      </div>
                      <div class="col-sm-4">
                          <input name="theSelectedStep.actions[${status.index}].actionId" class="form-control" placeholder='<op:translate key="ACTION_ID" />' value="${form.theSelectedStep.actions[status.index].actionId}" type="text">
                      </div>
                      <c:if test="${form.advancedMode}">
	                      <div class="col-sm-4">
	                          <input name="theSelectedStep.actions[${status.index}].stepReference" class="form-control" placeholder='<op:translate key="ACTION_TARGET_REF" />' value="${form.theSelectedStep.actions[status.index].stepReference}" type="text">
	                      </div>
                      </c:if>
                      <c:if test="${!form.advancedMode}">
                           <div class="col-sm-4">
		                        <form:select path="theSelectedStep.actions[${status.index}].stepReference" class="stepSelect-select2 form-control select2" cssStyle="width: 100%;" data-url="${stepSearchUrl}">
		                           <form:option value="${form.theSelectedStep.actions[status.index].stepReference}" />
		                        </form:select>
	                        </div>
                       </c:if>
                      
                      <div class="btn-group col-sm-2">
                          <button type="submit" name="editButton" class="btn btn-default" onclick="selector(this,'${status.index}','selectedButton')">
                              <i class="glyphicons glyphicons-edit"></i>
                          </button>
                          <button type="submit" name="deleteButton" class="btn btn-default" onclick="selector(this,'${status.index}','selectedButton')">
                              <i class="glyphicons glyphicons-bin"></i>
                          </button>
                      </div>
                  </li>
              </c:forEach>
          </ul>
	          
          <button type="submit" name="addButton" class="btn btn-default"><op:translate key="STEP_ADD_ACTION" /></button>
          <button type="submit" name="editButton" class="btn btn-default" onclick="selector(this,'-1','selectedButton')">
        	</i><op:translate key="STEP_EDIT_INIT_ACTION" />
          </button>
	    </div>
	    <div role="tabpanel" class="tab-pane" id="Mtadonnes">
		    <c:if test="${form.advancedMode}">
		       <div class="form-group">
		           <div class="col-sm-offset-2 col-sm-1">
			           <div class="checkbox">
		                    <label>
		                       <form:checkbox path="theSelectedStep.notifiable"/><span><op:translate key="STEP_CAN_NOTIFY" /></span>
		                    </label>
		                </div>
	                </div>
	                <div class="col-sm-1">
		                <div class="checkbox">
		                    <label>
		                       <form:checkbox path="theSelectedStep.acquitable"/><span><op:translate key="STEP_CAN_AKNOWLEDGE" /></span>
		                    </label>
		                </div>
	                </div>
	                <div class="col-sm-1">
                       <div class="checkbox">
                            <label>
                                  <form:checkbox path="theSelectedStep.notifEmail"/><span><op:translate key="STEP_NOTIFY_EMAIL" /></span>
                            </label>
                        </div>
                    </div>
		           <div class="col-sm-1">
			           <div class="checkbox">
			                <label>
			                      <form:checkbox path="theSelectedStep.closable"/><span><op:translate key="STEP_CAN_CLOSE" /></span>
			                </label>
		                </div>
	                </div>
		       </div>
	           <div class="form-group">
	               <form:label path="theSelectedStep.actionIdClosable" cssClass="col-sm-2 control-label"><op:translate key="STEP_CLOSE_ID" /></form:label>
	               <div class="col-sm-10">
	                   <form:input path="theSelectedStep.actionIdClosable" type="text" cssClass="form-control" />
	               </div>
	           </div>
	           <div class="form-group">
	               <form:label path="theSelectedStep.stringMsg" cssClass="col-sm-2 control-label"><op:translate key="STEP_NOTIFICATION_MSG" /></form:label>
	               <div class="col-sm-10">
	                   <form:input path="theSelectedStep.stringMsg" type="text" cssClass="form-control" />
	               </div>
	           </div>
	           <div class="form-group">
	               <form:label path="theSelectedStep.actionIdYes" cssClass="col-sm-2 control-label"><op:translate key="STEP_YES_ID" /></form:label>
	               <div class="col-sm-10">
	                   <form:input path="theSelectedStep.actionIdYes" type="text" cssClass="form-control" />
	               </div>
	           </div>
	           <div class="form-group">
	               <form:label path="theSelectedStep.actionIdNo" cssClass="col-sm-2 control-label"><op:translate key="STEP_NO_ID" /></form:label>
	               <div class="col-sm-10">
	                   <form:input path="theSelectedStep.actionIdNo" type="text" cssClass="form-control" />
	               </div>
	           </div>
	           <div class="form-group">
	               <form:label path="theSelectedStep.actionIdDefault" cssClass="col-sm-2 control-label"><op:translate key="STEP_DEFAULT_ID" /></form:label>
	               <div class="col-sm-10">
	                   <form:input path="theSelectedStep.actionIdDefault" cssClass="form-control" />
	               </div>
	           </div>
		    </c:if>
            <div class="form-group">
                <form:label path="theSelectedStep.actors" cssClass="col-sm-2 control-label"><op:translate key="ACTORS" /></form:label>
                <div class="col-sm-10">
                    <form:select path="theSelectedStep.actors" multiple="multiple" class="groupSelect-select2 form-control select2" cssStyle="width: 100%;" data-url="${groupSearchUrl}">
                        <form:options items="${form.theSelectedStep.actors}" />
                    </form:select>
                </div>
            </div>
            <div class="form-group">
                <form:label path="theSelectedStep.endStepMsg" cssClass="col-sm-2 control-label"><op:translate key="STEP_ENDSTEP_MSG" /></form:label>
                <div class="col-sm-10">
                    <form:input path="theSelectedStep.endStepMsg" cssClass="form-control" />
                </div>
            </div>
	    </div>
	</div>
    <hr>
    <button type="submit" class="btn btn-default" name="cancelStep"><op:translate key="CANCEL" /></button>
	<button type="submit" class="btn btn-primary" name="saveStep"><op:translate key="SAVE" /></button>
	<button type="submit" class="btn btn-danger pull-right" name="deleteStep"><op:translate key="DELETE" /></button>
	<input type="submit" class="hidden" name="updateForm">
	<input type="submit" class="hidden" name="selectField">
</form:form>