/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.batch.model;

import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.batch.AbstractBatch;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.rss.common.model.ContainerRssModel;
import org.osivia.services.rss.common.service.ContainerRssService;
import org.osivia.services.rss.common.service.FeedService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RssBatch
extends AbstractBatch {
    private static final String CRON_DEFAULT_VALUE = "0 0/10 * * * ?";
    private final Log log = LogFactory.getLog((String)"RSS_MANAGEMENT");
    private final String scheduling = System.getProperty("CRON_BATCH_RSS", "0 0/10 * * * ?");
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private FeedService feedService;
    @Autowired
    private ContainerRssService containerRssService;

    public String getJobScheduling() {
        return this.scheduling;
    }

    public void execute(Map<String, Object> parameters) throws PortalException {
        this.log.info((Object)"BATCH RSS de synchronisation des flux - Ex\u00e9cution - I00");
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, null, null);
        List containers = null;
        try {
            containers = this.containerRssService.getListContainer(portalControllerContext);
        }
        catch (Exception e) {
            this.log.error((Object)("BATCH RSS - E01 - methode containerRssService.getListContainer :" + e.getMessage() + ";"));
        }
        if (containers != null) {
            for (ContainerRssModel container : containers) {
                try {
                    List feeds = this.feedService.fillFeed(container.getDoc());
                    container.setFeedSources(feeds);
                }
                catch (PortletException e) {
                    this.log.error((Object)("BATCH RSS - E02 - m\u00e9thode feedService.fillFeed :" + container.getName() + ";" + e.getMessage() + ";"));
                }
                try {
                    this.feedService.synchro(portalControllerContext, container);
                }
                catch (PortletException e) {
                    this.log.error((Object)("BATCH RSS - E03 - m\u00e9thode feedService.synchro:" + e.getMessage() + ";"));
                }
            }
        }
        this.log.info((Object)"Fin de la synchronisation - I04");
    }
}

