/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.common.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.osivia.services.rss.feedRss.portlet.model.ItemRssModel;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ItemsDeleteCommand
implements INuxeoCommand {
    private final List<ItemRssModel> items;
    protected static final Log logger = LogFactory.getLog(ItemsDeleteCommand.class);

    public ItemsDeleteCommand(List<ItemRssModel> items) {
        this.items = items;
    }

    public Object execute(Session nuxeoSession) {
        for (ItemRssModel item : this.items) {
            DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
            try {
                documentService.remove(item.getDocid());
            }
            catch (Exception e) {
                logger.error((Object)("Erreur lors de la synchronisation pour le flux:" + item.getGuid() + ';' + e.getCause().getMessage()));
            }
        }
        return null;
    }

    public String getId() {
        return null;
    }
}

