/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.common.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.rss.common.command.FeedCreatCommand;
import org.osivia.services.rss.common.command.ItemListCommand;
import org.osivia.services.rss.common.command.ItemsDeleteCommand;
import org.osivia.services.rss.common.model.ContainerRssModel;
import org.osivia.services.rss.common.model.FeedRssModel;
import org.osivia.services.rss.common.model.Picture;
import org.osivia.services.rss.common.repository.FeedRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class FeedRepositoryImpl
implements FeedRepository {
    @Autowired
    private ApplicationContext applicationContext;

    public void creatFeed(PortalControllerContext portalControllerContext, ContainerRssModel model) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Document document = this.getCurrentDocument(portalControllerContext);
        model.setPath(nuxeoController.getCurrentDocumentContext().getCmsPath());
        model.setDoc(document);
        List feed = null;
        if (document != null) {
            feed = this.fillFeed(document, nuxeoController, model);
        }
        model.setFeedSources(feed);
        INuxeoCommand nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(FeedCreatCommand.class, new Object[]{model, "add"});
        nuxeoController.executeNuxeoCommand(nuxeoCommand);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(document.getPath());
        documentContext.reload();
        document = documentContext.getDocument();
    }

    public ContainerRssModel getListFeedRss(PortalControllerContext portalControllerContext) throws PortletException {
        Document document = this.getCurrentDocument(portalControllerContext);
        ContainerRssModel container = (ContainerRssModel)this.applicationContext.getBean(ContainerRssModel.class);
        container.setDoc(document);
        List feed = null;
        if (document != null) {
            feed = this.fillFeed(document);
        }
        container.setFeedSources(feed);
        return container;
    }

    public List<FeedRssModel> fillFeed(Document document) {
        ArrayList<FeedRssModel> listFeed = new ArrayList<FeedRssModel>();
        PropertyList propertyList = (PropertyList)document.getProperties().get("rssc:feeds");
        if (propertyList != null) {
            for (int i = 0; i < propertyList.size(); ++i) {
                PropertyMap map = propertyList.getMap(i);
                FeedRssModel feed = new FeedRssModel();
                feed.setSyncId(map.getString("syncId"));
                feed.setUrl(map.getString("url"));
                feed.setDisplayName(map.getString("displayName"));
                feed.setIndexNuxeo(i);
                listFeed.add(feed);
            }
        }
        return listFeed;
    }

    private List<FeedRssModel> fillFeed(Document document, NuxeoController nuxeoController, ContainerRssModel model) {
        ArrayList<FeedRssModel> listFeed = new ArrayList<FeedRssModel>();
        PropertyList propertyList = (PropertyList)document.getProperties().get("rssc:feeds");
        for (FeedRssModel feed : model.getFeedSources()) {
            model.setVisual(feed.getVisual());
            feed.getVisual().setName(feed.getSyncId());
            feed.setIndexNuxeo(propertyList.size());
            model.setFeed(feed);
            listFeed.add(feed);
        }
        return listFeed;
    }

    public Document getCurrentDocument(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
        Document document = documentContext == null ? null : documentContext.getDocument();
        return document;
    }

    public Map<String, String> getMapFeed(PortalControllerContext portalControllerContext) throws PortletException {
        PropertyList propertyList;
        HashMap<String, String> mapFeed = new HashMap<String, String>();
        Document document = this.getCurrentDocument(portalControllerContext);
        if (document != null && (propertyList = (PropertyList)document.getProperties().get("rssc:feeds")) != null) {
            for (int i = 0; i < propertyList.size(); ++i) {
                PropertyMap map = propertyList.getMap(i);
                mapFeed.put(map.getString("displayName"), map.getString("url"));
            }
        }
        return mapFeed;
    }

    public FeedRssModel getMapFeed(PortalControllerContext portalControllerContext, String id, String name, String url, int index) throws PortletException {
        PropertyList propertyList;
        FeedRssModel model = (FeedRssModel)this.applicationContext.getBean(FeedRssModel.class);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        HashMap<String, String> mapFeed = new HashMap<String, String>();
        Document document = this.getCurrentDocument(portalControllerContext);
        nuxeoController.setCurrentDoc(document);
        boolean init = false;
        if (model.getSyncId() == null) {
            init = true;
        }
        if (document != null && (propertyList = (PropertyList)document.getProperties().get("rssc:feeds")) != null) {
            for (int i = 0; i < propertyList.size(); ++i) {
                PropertyMap map = propertyList.getMap(i);
                mapFeed.put(map.getString("displayName"), map.getString("url"));
                if (!init || !id.equalsIgnoreCase(map.getString("syncId"))) continue;
                model.setDisplayName(map.getString("displayName"));
                model.setSyncId(id);
                model.setUrl(map.getString("url"));
                Picture visual = (Picture)this.applicationContext.getBean(Picture.class);
                visual.setUrl(nuxeoController.createFileLink(document, "rssc:feeds/" + i + "/" + "logos"));
                model.setVisual(visual);
                model.setIndexNuxeo(index);
            }
        }
        if (name != null && url == null) {
            mapFeed = null;
        } else {
            model.setMap(mapFeed);
        }
        return model;
    }

    public void modFeed(PortalControllerContext portalControllerContext, FeedRssModel model) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        ContainerRssModel container = (ContainerRssModel)this.applicationContext.getBean(ContainerRssModel.class);
        Document document = this.getCurrentDocument(portalControllerContext);
        container.setPath(nuxeoController.getCurrentDocumentContext().getCmsPath());
        container.setDoc(document);
        container.setFeed(model);
        container.setVisual(model.getVisual());
        INuxeoCommand nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(FeedCreatCommand.class, new Object[]{container, "mod"});
        nuxeoController.executeNuxeoCommand(nuxeoCommand);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(document.getPath());
        documentContext.reload();
        document = documentContext.getDocument();
    }

    public void delFeed(PortalControllerContext portalControllerContext, FeedRssModel model) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        ContainerRssModel container = (ContainerRssModel)this.applicationContext.getBean(ContainerRssModel.class);
        Document document = this.getCurrentDocument(portalControllerContext);
        container.setPath(nuxeoController.getCurrentDocumentContext().getCmsPath());
        container.setDoc(document);
        container.setFeed(model);
        container.setVisual(model.getVisual());
        INuxeoCommand nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(FeedCreatCommand.class, new Object[]{container, "del"});
        nuxeoController.executeNuxeoCommand(nuxeoCommand);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(document.getPath());
        documentContext.reload();
        document = documentContext.getDocument();
        nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(ItemListCommand.class, new Object[]{model.getSyncId()});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(nuxeoCommand);
        ArrayList<String> items = new ArrayList<String>(documents.size());
        for (Document doc : documents) {
            items.add(doc.getId());
        }
        nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(ItemsDeleteCommand.class, new Object[]{items});
        nuxeoController.executeNuxeoCommand(nuxeoCommand);
    }
}

