/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.search.portlet.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.page.PageParametersEncoder;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.search.portlet.model.SearchForm;
import org.osivia.services.search.portlet.model.SearchSettings;
import org.osivia.services.search.portlet.model.TaskPath;
import org.osivia.services.search.portlet.repository.SearchRepository;
import org.osivia.services.search.portlet.service.SearchService;
import org.osivia.services.search.selector.type.portlet.model.SearchType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class SearchServiceImpl
implements SearchService {
    private static final String TASKPATH_WINDOW_PROPERTY = "osivia.collaboration.search.taskpath";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SearchRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;

    public SearchForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        return (SearchForm)this.applicationContext.getBean(SearchForm.class);
    }

    public String search(PortalControllerContext portalControllerContext, SearchForm form) throws PortletException {
        String redirectionUrl;
        Document root = this.repository.getRoot(portalControllerContext);
        if (root == null) {
            try {
                Map selectors = PageParametersEncoder.decodeProperties(null);
                selectors.put("type", Arrays.asList(SearchType.WORKSPACE.getDocType()));
                redirectionUrl = this.portalUrlFactory.getAdvancedSearchUrl(portalControllerContext, form.getQuery(), false, selectors);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        } else {
            TaskPath path = null;
            SearchSettings settings = this.getSettings(portalControllerContext);
            if (settings.getTaskPath() != null) {
                path = (TaskPath)this.applicationContext.getBean(TaskPath.class);
                path.setCmsPath(settings.getTaskPath());
            } else {
                path = this.repository.getSearchTaskPath(portalControllerContext, root.getPath());
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            Map selectors = PageParametersEncoder.decodeProperties(null);
            String query = StringUtils.trim((String)form.getQuery());
            if (StringUtils.isNotEmpty((String)query)) {
                selectors.put("search", Arrays.asList(query));
            }
            selectors.put("scope", Arrays.asList(root.getPath()));
            String workspaceId = root.getProperties().getString("webc:url");
            if (StringUtils.isNotEmpty((String)workspaceId)) {
                selectors.put("workspaceId", Arrays.asList(workspaceId));
            }
            parameters.put("selectors", PageParametersEncoder.encodeProperties((Map)selectors));
            String displayContext = path.isUpdated() ? "refreshPageAndNavigation" : null;
            redirectionUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path.getCmsPath(), parameters, null, displayContext, null, null, null, null);
        }
        return redirectionUrl;
    }

    public SearchSettings getSettings(PortalControllerContext portalControllerContext) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        SearchSettings settings = (SearchSettings)this.applicationContext.getBean(SearchSettings.class);
        String taskPath = window.getProperty(TASKPATH_WINDOW_PROPERTY);
        settings.setTaskPath(taskPath);
        return settings;
    }

    public void save(PortalControllerContext portalControllerContext, SearchSettings settings) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String taskPath = StringUtils.trimToNull((String)settings.getTaskPath());
        window.setProperty(TASKPATH_WINDOW_PROPERTY, taskPath);
    }
}

