/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.statistics.portlet.configuration;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import javax.annotation.PostConstruct;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.statistics.IStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Configuration
@ComponentScan(basePackages={"org.osivia.services.statistics.portlet"})
public class StatisticsConfiguration
extends CMSPortlet {
    @Autowired
    private PortletConfig portletConfig;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @Bean
    public InternalResourceViewResolver getViewResolver() {
        InternalResourceViewResolver viewResolver = new InternalResourceViewResolver();
        viewResolver.setCache(true);
        viewResolver.setViewClass(JstlView.class);
        viewResolver.setPrefix("/WEB-INF/jsp/");
        viewResolver.setSuffix(".jsp");
        return viewResolver;
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("Resource");
        return messageSource;
    }

    @Bean
    public IBundleFactory getBundleFactory() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        return internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    @Bean
    public IStatisticsService getStatisticsService() {
        return (IStatisticsService)Locator.findMBean(IStatisticsService.class, (String)"osivia:service=StatisticsService");
    }
}

