/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.statistics.portlet.service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.time.DateUtils;
import org.dom4j.Element;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.statistics.IStatisticsService;
import org.osivia.portal.api.statistics.SpaceStatistics;
import org.osivia.portal.api.statistics.SpaceVisits;
import org.osivia.services.statistics.portlet.model.CreationsView;
import org.osivia.services.statistics.portlet.model.StatisticsForm;
import org.osivia.services.statistics.portlet.model.StatisticsWindowSettings;
import org.osivia.services.statistics.portlet.model.VisitsView;
import org.osivia.services.statistics.portlet.repository.StatisticsPortletRepository;
import org.osivia.services.statistics.portlet.service.StatisticsPortletService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class StatisticsPortletServiceImpl
implements StatisticsPortletService {
    private static final int DEFAULT_DAYS_HISTORY = 30;
    private static final int DEFAULT_MONTHS_HISTORY = 12;
    private static final String RED = "rgb(255, 99, 132)";
    private static final String BLUE = "rgb(54, 162, 235)";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private StatisticsPortletRepository repository;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private IStatisticsService statisticsService;

    public StatisticsWindowSettings getWindowSettings(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getWindowSettings(portalControllerContext);
    }

    public void saveWindowSettings(PortalControllerContext portalControllerContext, StatisticsWindowSettings windowSettings) throws PortletException {
        this.repository.saveWindowSettings(portalControllerContext, windowSettings);
    }

    public StatisticsForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        StatisticsForm form = (StatisticsForm)this.applicationContext.getBean(StatisticsForm.class);
        form.setCreationsView(CreationsView.DEFAULT);
        form.setVisitsView(VisitsView.DEFAULT);
        return form;
    }

    public JSONObject getCreations(PortalControllerContext portalControllerContext, CreationsView view) throws PortletException {
        StatisticsWindowSettings windowSettings = this.getWindowSettings(portalControllerContext);
        Map periods = this.repository.getDocumentsCountsByPeriods(portalControllerContext, windowSettings);
        JSONObject result = new JSONObject();
        result.put((Object)"type", (Object)"bar");
        result.put((Object)"options", (Object)this.getChartOptions(portalControllerContext));
        result.put((Object)"data", (Object)this.getCreationsChartData(portalControllerContext, periods, view));
        result.put((Object)"table", (Object)this.getCreationsTableBody(portalControllerContext, periods));
        return result;
    }

    private JSONObject getCreationsChartData(PortalControllerContext portalControllerContext, Map<String, Integer[]> periods, CreationsView view) throws PortletException {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        int index = CreationsView.DIFFERENTIAL.equals((Object)view) ? 0 : 1;
        JSONArray labels = new JSONArray();
        JSONArray values = new JSONArray();
        for (Map.Entry<String, Integer[]> period : periods.entrySet()) {
            labels.add((Object)period.getKey());
            values.add((Object)period.getValue()[index]);
        }
        JSONObject dataset = new JSONObject();
        dataset.put((Object)"label", (Object)bundle.getString(view.getKey()));
        dataset.put((Object)"borderColor", (Object)BLUE);
        dataset.put((Object)"backgroundColor", (Object)BLUE);
        dataset.put((Object)"data", (Object)values);
        JSONArray datasets = new JSONArray();
        datasets.add((Object)dataset);
        JSONObject data = new JSONObject();
        data.put((Object)"labels", (Object)labels);
        data.put((Object)"datasets", (Object)datasets);
        return data;
    }

    private String getCreationsTableBody(PortalControllerContext portalControllerContext, Map<String, Integer[]> periods) {
        Element tbody = DOM4JUtils.generateElement((String)"tbody", null, (String)"");
        for (Map.Entry<String, Integer[]> period : periods.entrySet()) {
            Element tr = DOM4JUtils.generateElement((String)"tr", null, null);
            tbody.add(tr);
            Element label = DOM4JUtils.generateElement((String)"td", null, (String)period.getKey());
            tr.add(label);
            for (int i = 0; i < 2; ++i) {
                Element value = DOM4JUtils.generateElement((String)"td", null, (String)String.valueOf(period.getValue()[i]));
                tr.add(value);
            }
        }
        return DOM4JUtils.writeCompact((Element)tbody);
    }

    public JSONObject getVisits(PortalControllerContext portalControllerContext, VisitsView view) throws PortletException {
        SpaceStatistics statistics;
        String path = this.repository.getSpacePath(portalControllerContext);
        try {
            statistics = this.statisticsService.getSpaceStatistics(portalControllerContext, path);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        JSONObject result = new JSONObject();
        result.put((Object)"type", (Object)"line");
        result.put((Object)"options", (Object)this.getChartOptions(portalControllerContext));
        if (statistics != null) {
            result.put((Object)"data", (Object)this.getVisitsChartData(portalControllerContext, view, statistics));
            result.put((Object)"table", (Object)this.getVisitsTableBody(portalControllerContext, view, statistics));
        }
        return result;
    }

    private JSONObject getVisitsChartData(PortalControllerContext portalControllerContext, VisitsView view, SpaceStatistics statistics) throws PortletException {
        Map periods;
        SimpleDateFormat subLabelFormat;
        SimpleDateFormat labelFormat;
        int historySize;
        int field;
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        StatisticsWindowSettings windowSettings = this.getWindowSettings(portalControllerContext);
        if (VisitsView.MONTHS.equals((Object)view)) {
            field = 2;
            historySize = windowSettings.getVisitsMonths();
            if (historySize < 1) {
                historySize = 12;
            }
            labelFormat = new SimpleDateFormat("MMM", locale);
            subLabelFormat = new SimpleDateFormat("yyyy", locale);
            periods = statistics.getHistorizedMonthsVisits();
        } else {
            field = 5;
            historySize = windowSettings.getVisitsDays();
            if (historySize < 1) {
                historySize = 30;
            }
            labelFormat = new SimpleDateFormat("d", locale);
            subLabelFormat = new SimpleDateFormat("MMM", locale);
            periods = statistics.getHistorizedDaysVisits();
        }
        Date currentPeriod = DateUtils.truncate((Date)new Date(), (int)field);
        JSONArray labels = new JSONArray();
        JSONArray hitsData = new JSONArray();
        JSONArray uniqueVisitorsData = new JSONArray();
        for (int i = 1; i <= historySize; ++i) {
            SpaceVisits visits;
            Date date;
            if (i == historySize) {
                date = currentPeriod;
                visits = VisitsView.MONTHS.equals((Object)view) ? statistics.getCurrentMonthVisits() : statistics.getCurrentDayVisits();
            } else {
                date = VisitsView.MONTHS.equals((Object)view) ? DateUtils.addMonths((Date)currentPeriod, (int)(i - historySize)) : DateUtils.addDays((Date)currentPeriod, (int)(i - historySize));
                visits = (SpaceVisits)periods.get(date);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            boolean displaySubLabel = i == 1 || VisitsView.DAYS.equals((Object)view) && calendar.get(field) == 1 || VisitsView.MONTHS.equals((Object)view) && calendar.get(field) == 0;
            String label = labelFormat.format(date);
            if (displaySubLabel) {
                JSONArray multilineLabel = new JSONArray();
                multilineLabel.add((Object)label);
                multilineLabel.add((Object)subLabelFormat.format(date));
                labels.add((Object)multilineLabel);
            } else {
                labels.add((Object)label);
            }
            if (visits == null) {
                hitsData.add((Object)0);
                uniqueVisitorsData.add((Object)0);
                continue;
            }
            hitsData.add((Object)visits.getHits());
            if (i == historySize) {
                uniqueVisitorsData.add((Object)(visits.getVisitors().size() + visits.getAnonymousVisitors()));
                continue;
            }
            uniqueVisitorsData.add((Object)visits.getUniqueVisitors());
        }
        JSONObject hits = new JSONObject();
        hits.put((Object)"label", (Object)bundle.getString("VISITS_HITS"));
        hits.put((Object)"borderColor", (Object)RED);
        hits.put((Object)"backgroundColor", (Object)RED);
        hits.put((Object)"fill", (Object)false);
        hits.put((Object)"lineTension", (Object)0);
        hits.put((Object)"data", (Object)hitsData);
        JSONObject uniqueVisitors = new JSONObject();
        uniqueVisitors.put((Object)"label", (Object)bundle.getString("VISITS_UNIQUE_VISITORS"));
        uniqueVisitors.put((Object)"borderColor", (Object)BLUE);
        uniqueVisitors.put((Object)"backgroundColor", (Object)BLUE);
        uniqueVisitors.put((Object)"fill", (Object)false);
        uniqueVisitors.put((Object)"lineTension", (Object)0);
        uniqueVisitors.put((Object)"data", (Object)uniqueVisitorsData);
        JSONArray datasets = new JSONArray();
        datasets.add((Object)hits);
        datasets.add((Object)uniqueVisitors);
        JSONObject data = new JSONObject();
        data.put((Object)"labels", (Object)labels);
        data.put((Object)"datasets", (Object)datasets);
        return data;
    }

    private String getVisitsTableBody(PortalControllerContext portalControllerContext, VisitsView view, SpaceStatistics statistics) throws PortletException {
        Map periods;
        DateFormat labelFormat;
        int historySize;
        int field;
        Locale locale = portalControllerContext.getRequest().getLocale();
        StatisticsWindowSettings windowSettings = this.getWindowSettings(portalControllerContext);
        if (VisitsView.MONTHS.equals((Object)view)) {
            field = 2;
            historySize = windowSettings.getVisitsMonths();
            if (historySize < 1) {
                historySize = 12;
            }
            labelFormat = new SimpleDateFormat("MMMM yyyy", locale);
            periods = statistics.getHistorizedMonthsVisits();
        } else {
            field = 5;
            historySize = windowSettings.getVisitsDays();
            if (historySize < 1) {
                historySize = 30;
            }
            labelFormat = DateFormat.getDateInstance(0, locale);
            periods = statistics.getHistorizedDaysVisits();
        }
        Date currentPeriod = DateUtils.truncate((Date)new Date(), (int)field);
        Element tbody = DOM4JUtils.generateElement((String)"tbody", null, (String)"");
        for (int i = 1; i <= historySize; ++i) {
            String uniqueVisitorsValue;
            String hitsValue;
            SpaceVisits visits;
            Date date;
            if (i == historySize) {
                date = currentPeriod;
                visits = VisitsView.MONTHS.equals((Object)view) ? statistics.getCurrentMonthVisits() : statistics.getCurrentDayVisits();
            } else {
                date = VisitsView.MONTHS.equals((Object)view) ? DateUtils.addMonths((Date)currentPeriod, (int)(i - historySize)) : DateUtils.addDays((Date)currentPeriod, (int)(i - historySize));
                visits = (SpaceVisits)periods.get(date);
            }
            if (visits == null) {
                hitsValue = String.valueOf(0);
                uniqueVisitorsValue = String.valueOf(0);
            } else {
                hitsValue = String.valueOf(visits.getHits());
                uniqueVisitorsValue = i == historySize ? String.valueOf(visits.getVisitors().size() + visits.getAnonymousVisitors()) : String.valueOf(visits.getUniqueVisitors());
            }
            Element tr = DOM4JUtils.generateElement((String)"tr", null, null);
            tbody.add(tr);
            Element label = DOM4JUtils.generateElement((String)"td", null, (String)labelFormat.format(date));
            tr.add(label);
            Element hits = DOM4JUtils.generateElement((String)"td", null, (String)hitsValue);
            tr.add(hits);
            Element uniqueVisitors = DOM4JUtils.generateElement((String)"td", null, (String)uniqueVisitorsValue);
            tr.add(uniqueVisitors);
        }
        return DOM4JUtils.writeCompact((Element)tbody);
    }

    private JSONObject getChartOptions(PortalControllerContext portalControllerContext) {
        JSONObject ticks = new JSONObject();
        ticks.put((Object)"min", (Object)0);
        JSONObject yAxis1 = new JSONObject();
        yAxis1.put((Object)"id", (Object)"y-axis-1");
        yAxis1.put((Object)"type", (Object)"linear");
        yAxis1.put((Object)"position", (Object)"left");
        yAxis1.put((Object)"ticks", (Object)ticks);
        JSONArray yAxes = new JSONArray();
        yAxes.add((Object)yAxis1);
        JSONObject scales = new JSONObject();
        scales.put((Object)"yAxes", (Object)yAxes);
        JSONObject tooltips = new JSONObject();
        tooltips.put((Object)"mode", (Object)"index");
        tooltips.put((Object)"intersect", (Object)false);
        JSONObject options = new JSONObject();
        options.put((Object)"maintainAspectRatio", (Object)false);
        options.put((Object)"scales", (Object)scales);
        options.put((Object)"tooltips", (Object)tooltips);
        return options;
    }
}

