/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.taskbar.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.taskbar.portlet.model.Task;
import org.osivia.services.taskbar.portlet.model.TaskbarSettings;
import org.osivia.services.taskbar.portlet.service.TaskbarPortletService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class TaskbarViewController
extends CMSPortlet {
    @Autowired
    private PortletConfig portletConfig;
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private TaskbarPortletService service;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="settings") TaskbarSettings settings) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        List tasks = this.service.getTasks(portalControllerContext, settings);
        this.service.updateTasks(portalControllerContext, tasks);
        request.setAttribute("tasks", (Object)tasks);
        return settings.getView().getPath();
    }

    @ActionMapping(value="start")
    public void start(ActionRequest request, ActionResponse response, @RequestParam(value="id") String id, @ModelAttribute(value="settings") TaskbarSettings settings) throws IOException, PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        Task task = this.service.start(portalControllerContext, settings, id);
        response.sendRedirect(task.getUrl());
    }

    @ModelAttribute(value="settings")
    public TaskbarSettings getSettings(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getSettings(portalControllerContext);
    }
}

