/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.taskbar.portlet.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.taskbar.portlet.model.TaskbarSettings;
import org.osivia.services.taskbar.portlet.model.TaskbarView;
import org.osivia.services.taskbar.portlet.service.TaskbarPortletService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"ADMIN"})
public class TaskbarAdminController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private TaskbarPortletService service;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="settings") TaskbarSettings settings) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        String order = StringUtils.join((Collection)settings.getOrder(), (String)"|");
        request.setAttribute("order", (Object)order);
        List orderedTasks = this.service.getOrderedItems(portalControllerContext);
        request.setAttribute("orderedItems", (Object)orderedTasks);
        List availableTasks = this.service.getAvailableItems(portalControllerContext);
        request.setAttribute("availableItems", (Object)availableTasks);
        return "admin";
    }

    @ActionMapping(value="save")
    public void save(ActionRequest request, ActionResponse response, @RequestParam(value="order") String order, @ModelAttribute(value="settings") TaskbarSettings settings) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        settings.setOrder(Arrays.asList(StringUtils.split((String)order, (String)"|")));
        this.service.saveSettings(portalControllerContext, settings);
        response.setWindowState(WindowState.NORMAL);
        response.setPortletMode(PortletMode.VIEW);
    }

    @ModelAttribute(value="settings")
    public TaskbarSettings getConfiguration(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getSettings(portalControllerContext);
    }

    @ModelAttribute(value="views")
    public List<TaskbarView> getViews(PortletRequest request, PortletResponse response) throws PortletException {
        return Arrays.asList(TaskbarView.values());
    }
}

