/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.tasks.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.tasks.portlet.model.Tasks;
import org.osivia.services.tasks.portlet.service.TasksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"tasks"})
public class TasksController
extends CMSPortlet
implements PortletConfigAware,
PortletContextAware {
    private PortletConfig portletConfig;
    private PortletContext portletContext;
    @Autowired
    private TasksService service;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="tasks") Tasks tasks, @RequestParam(name="reload", required=false) String reload) {
        request.setAttribute("reload", (Object)BooleanUtils.toBoolean((String)reload));
        request.setAttribute("tasksCount", (Object)tasks.getCount());
        return "view";
    }

    @ActionMapping(value="accept")
    public void accept(ActionRequest request, ActionResponse response, @ModelAttribute(value="tasks") Tasks tasks, @RequestParam String index) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.acceptTask(portalControllerContext, tasks, NumberUtils.toInt((String)index));
    }

    @ActionMapping(value="reject")
    public void reject(ActionRequest request, ActionResponse response, @ModelAttribute(value="tasks") Tasks tasks, @RequestParam String index) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.rejectTask(portalControllerContext, tasks, NumberUtils.toInt((String)index));
    }

    @ActionMapping(value="close")
    public void close(ActionRequest request, ActionResponse response, @ModelAttribute(value="tasks") Tasks tasks, @RequestParam String index) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.closeTask(portalControllerContext, tasks, NumberUtils.toInt((String)index));
    }

    @ModelAttribute(value="tasks")
    public Tasks getTasks(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getTasks(portalControllerContext);
    }

    @ModelAttribute(value="reloadUrl")
    public String getReloadUrl(PortletRequest request, PortletResponse response) {
        return NuxeoConnectionProperties.getPublicBaseUri() + "/logout";
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

