/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.tasks.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.math.NumberUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.tasks.ITasksService;
import org.osivia.services.tasks.portlet.model.Tasks;
import org.osivia.services.tasks.portlet.service.TasksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"tasks"})
public class TasksController
extends CMSPortlet
implements PortletConfigAware,
PortletContextAware {
    private PortletConfig portletConfig;
    private PortletContext portletContext;
    @Autowired
    private TasksService service;
    @Autowired
    private ITasksService tasksService;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="tasks") Tasks tasks) throws PortletException {
        request.setAttribute("tasksCount", (Object)tasks.getCount());
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        request.setAttribute("discussionUrl", (Object)this.service.getDiscussionsUrl(portalControllerContext));
        try {
            this.tasksService.resetTasksCount(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return "view";
    }

    @ActionMapping(value="accept")
    public void accept(ActionRequest request, ActionResponse response, @ModelAttribute(value="tasks") Tasks tasks, @RequestParam String index) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.acceptTask(portalControllerContext, tasks, NumberUtils.toInt((String)index));
    }

    @ActionMapping(value="reject")
    public void reject(ActionRequest request, ActionResponse response, @ModelAttribute(value="tasks") Tasks tasks, @RequestParam String index) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.rejectTask(portalControllerContext, tasks, NumberUtils.toInt((String)index));
    }

    @ActionMapping(value="close")
    public void close(ActionRequest request, ActionResponse response, @ModelAttribute(value="tasks") Tasks tasks, @RequestParam String index) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.closeTask(portalControllerContext, tasks, NumberUtils.toInt((String)index));
    }

    @ModelAttribute(value="tasks")
    public Tasks getTasks(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getTasks(portalControllerContext);
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

