/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.tasks.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.discussions.DiscussionHelper;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.TaskDirective;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.directory.v2.service.preferences.UserPreferencesService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.tasks.CustomTask;
import org.osivia.portal.api.tasks.ITasksService;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.services.tasks.portlet.model.Task;
import org.osivia.services.tasks.portlet.model.TaskActionType;
import org.osivia.services.tasks.portlet.repository.TasksRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class TasksRepositoryImpl
implements TasksRepository {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ITasksService tasksService;
    @Autowired
    private IFormsService formsService;
    @Autowired
    private PersonService personService;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private UserPreferencesService userPreferencesService;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;

    public List<Task> getTasks(PortalControllerContext portalControllerContext) throws PortletException {
        List documents;
        try {
            documents = this.tasksService.getTasks(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        ArrayList<Task> tasks = new ArrayList<Task>(documents.size());
        for (EcmDocument ecmDocument : documents) {
            String display;
            Document document;
            if (ecmDocument instanceof Document && (document = (Document)ecmDocument).getType().equals("TaskDoc") && StringUtils.isNotBlank((String)(display = this.getTaskDisplay(portalControllerContext, document)))) {
                PropertyMap taskVariables = document.getProperties().getMap("nt:task_variables");
                Person initiator = this.personService.getPerson(document.getString("nt:initiator"));
                Task task = (Task)this.applicationContext.getBean(Task.class);
                task.setDocument(document);
                task.setDisplay(display);
                task.setInitiator(initiator);
                task.setDate(document.getDate("dc:created"));
                task.setAcknowledgeable(BooleanUtils.isTrue((Boolean)taskVariables.getBoolean("acquitable")));
                task.setCloseable(BooleanUtils.isTrue((Boolean)taskVariables.getBoolean("closable")));
                tasks.add(task);
            }
            if (!(ecmDocument instanceof CustomTask)) continue;
            CustomTask customTask = (CustomTask)ecmDocument;
            Document document2 = (Document)customTask.getInnerDocument();
            Task task = (Task)this.applicationContext.getBean(Task.class);
            task.setDocument(document2);
            try {
                String subject;
                Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
                if (customTask.getProperties().get("pubTitle") != null) {
                    subject = (String)customTask.getProperties().get("pubTitle");
                } else if (customTask.getProperties().get("author") != null) {
                    Person person = this.personService.getPerson((String)customTask.getProperties().get("author"));
                    if (person != null) {
                        subject = StringUtils.defaultIfBlank((String)person.getDisplayName(), (String)"");
                    }
                    subject = (String)customTask.getProperties().get("author");
                } else {
                    subject = "";
                }
                if (subject.length() > 0) {
                    subject = "(" + subject + ")";
                }
                String url = DiscussionHelper.getDiscussionUrlById((PortalControllerContext)portalControllerContext, (String)document2.getProperties().getString("ttc:webid"));
                task.setDisplay(" <a href=\"" + url + "\">" + bundle.getString("TASK_DISCUSSIONS_NEW_MESSAGE") + "</a> " + subject);
                tasks.add(task);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        return tasks;
    }

    private String getTaskDisplay(PortalControllerContext portalControllerContext, Document task) throws PortletException {
        String display;
        TaskDirective directive;
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        PropertyMap taskVariables = task.getProperties().getMap("nt:task_variables");
        String directiveId = task.getString("nt:directive");
        String expression = null;
        if (BooleanUtils.isTrue((Boolean)taskVariables.getBoolean("notifiable"))) {
            expression = taskVariables.getString("stringMsg");
        } else if (StringUtils.isNotEmpty((String)directiveId) && (directive = TaskDirective.fromId((String)directiveId)) != null) {
            String key = "TASK_DIRECTIVE_" + StringUtils.upperCase((String)directive.toString());
            expression = bundle.getString(key);
        }
        if (StringUtils.isNotBlank((String)expression)) {
            String transformedExpression;
            try {
                transformedExpression = this.formsService.transform(portalControllerContext, expression, task);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
            display = StringUtils.replace((String)transformedExpression, (String)System.lineSeparator(), (String)"<br>");
        } else {
            display = null;
        }
        return display;
    }

    public String getHelp(PortalControllerContext portalControllerContext) throws PortletException {
        String help;
        String location = System.getProperty("tasks.help.location");
        if (StringUtils.isBlank((String)location)) {
            help = null;
        } else {
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            String path = location.startsWith("/") ? location : NuxeoController.webIdToFetchPath((String)location);
            try {
                NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
                Document document = documentContext.getDocument();
                help = nuxeoController.transformHTMLContent(StringUtils.trimToEmpty((String)document.getString("note:note")));
            }
            catch (NuxeoException e) {
                if (e.getErrorCode() == 3) {
                    help = null;
                }
                throw e;
            }
        }
        return help;
    }

    public String updateTask(PortalControllerContext portalControllerContext, Task task, TaskActionType actionType) throws PortletException {
        String message;
        EcmDocument ecmDocument;
        String path = task.getDocument().getPath();
        try {
            ecmDocument = this.tasksService.getTask(portalControllerContext, path);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        if (ecmDocument != null && ecmDocument instanceof Document) {
            Document document = (Document)ecmDocument;
            PropertyMap taskVariables = document.getProperties().getMap("nt:task_variables");
            String actionId = taskVariables.getString(actionType.getActionReference());
            try {
                Map updatedVariables = this.formsService.proceed(portalControllerContext, document, actionId, null);
                message = (String)updatedVariables.get("tasksNotificationMessage");
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
            catch (FormFilterException e) {
                throw new PortletException((Throwable)e);
            }
        } else {
            message = null;
        }
        return message;
    }
}

