/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.versions.plugin;

import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;

public class VersionsMenubarModule
implements MenubarModule {
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IBundleFactory bundleFactory;

    public VersionsMenubarModule() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext spaceDocumentContext) throws PortalException {
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        DocumentType type;
        PortletRequest request = portalControllerContext.getRequest();
        if (request != null && request.getRemoteUser() != null && documentContext != null && ContextualizationHelper.isCurrentDocContextualized((PortalControllerContext)portalControllerContext) && (type = documentContext.getDocumentType()) != null && "File".equals(type.getName())) {
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            Document document = (Document)documentContext.getDocument();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.cms.uri", document.getPath());
            String id = "VERSIONS";
            String title = bundle.getString("VERSIONS_MENUBAR_ITEM");
            String icon = "glyphicons glyphicons-history";
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
            int order = 10;
            String url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-versions-instance", properties, PortalUrlType.POPUP);
            String target = null;
            String onclick = null;
            String htmlClasses = "fancyframe";
            MenubarItem item = new MenubarItem(id, title, icon, (MenubarContainer)parent, order, url, target, onclick, htmlClasses);
            item.setAjaxDisabled(true);
            item.setDivider(true);
            menubar.add(item);
        }
    }
}

