/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin;

import fr.toutatice.portail.cms.nuxeo.api.FileBrowserView;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import fr.toutatice.portail.cms.nuxeo.api.plugin.PluginModule;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentState;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.player.Player;

public class DocumentUrlContainerPlayer
extends PluginModule
implements INuxeoPlayerModule {
    public DocumentUrlContainerPlayer(PortletContext portletContext) {
        super(portletContext);
    }

    public Player getCMSPlayer(DocumentContext<Document> docCtx) {
        boolean workspace;
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        Document doc = (Document)docCtx.getDoc();
        boolean bl = workspace = navigationInfos.isContextualized() && navigationInfos.isLiveSpace();
        if ("DocumentUrlContainer".equals(doc.getType())) {
            if (workspace) {
                navigationInfos.setState(DocumentState.LIVE);
                Player properties = this.getNuxeoCustomizer().getCMSFileBrowser(docCtx);
                Map windowProperties = properties.getWindowProperties();
                windowProperties.put("osivia.title", doc.getTitle());
                windowProperties.put("osivia.defaultView", FileBrowserView.THUMBNAILS.getName());
                return properties;
            }
            return this.getCMSUrlContainerPlayer(docCtx);
        }
        return null;
    }

    public Player getCMSUrlContainerPlayer(DocumentContext<Document> docCtx) {
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", NuxeoController.createFolderRequest(docCtx, (boolean)true));
        windowProperties.put("osivia.cms.style", "contextual-links");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", navigationInfos.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", navigationInfos.getState().toString());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }
}

