/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.widgets.plugin.SummaryFragmentModule;

public class SummaryFragmentModule
extends FragmentModule {
    public static final String ID = "fgts_summary";
    private static final String VIEW_JSP_NAME = "summary";

    public SummaryFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }

    public void doView(PortalControllerContext portalControllerContext) throws PortletException {
        LinkedHashMap resultFragments = new LinkedHashMap();
        RenderRequest request = (RenderRequest)portalControllerContext.getRequest();
        RenderResponse response = (RenderResponse)portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        if (StringUtils.isNotEmpty((String)nuxeoPath)) {
            PropertyList regionsList;
            Document document = nuxeoController.fetchDocument(nuxeoPath = nuxeoController.getComputedPath(nuxeoPath));
            Object regions = document.getProperties().get("smyfgt:summaryFragment");
            if (regions instanceof PropertyList && (regionsList = (PropertyList)regions) != null && regionsList.size() > 0) {
                for (int index = 0; index < regionsList.size(); ++index) {
                    PropertyMap regionMap = ((PropertyList)regions).getMap(index);
                    String region = regionMap.getString(GenericProperties.regionId.name());
                    PropertyList fragments = document.getProperties().getList("fgts:fragments");
                    if (fragments == null || fragments.isEmpty()) continue;
                    resultFragments.putAll(this.filterNOrderByRegion(fragments, region));
                }
            }
            if (!resultFragments.isEmpty()) {
                request.setAttribute("fragments", resultFragments);
            }
        }
    }

    private Map<String, String> filterNOrderByRegion(PropertyList fragments, String region) {
        LinkedHashMap<String, String> resultFgts = new LinkedHashMap<String, String>();
        PropertyList filteredFragments = this.filterFragments(fragments, region);
        PropertyList orderedFragments = this.orderFragments(filteredFragments);
        for (int index = 0; index < orderedFragments.size(); ++index) {
            PropertyMap fragment = orderedFragments.getMap(index);
            if (fragment.getBoolean(GenericProperties.hideTitle.name()).booleanValue()) continue;
            String uri = fragment.getString(GenericProperties.uri.name());
            String title = fragment.getString(GenericProperties.title.name());
            resultFgts.put("#" + uri, title);
        }
        return resultFgts;
    }

    private PropertyList filterFragments(PropertyList fragments, String region) {
        ArrayList filteredFgts = new ArrayList(fragments.size());
        for (Object fragmentObj : fragments.list()) {
            PropertyMap fragment = (PropertyMap)fragmentObj;
            if (!region.equals(fragment.getString(GenericProperties.regionId.name()))) continue;
            filteredFgts.add(fragmentObj);
        }
        return new PropertyList(filteredFgts);
    }

    private PropertyList orderFragments(PropertyList fragments) {
        ArrayList fgtsAsList = new ArrayList(fragments.list());
        Collections.sort(fgtsAsList, new /* Unavailable Anonymous Inner Class!! */);
        return new PropertyList(fgtsAsList);
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
    }

    public void processAction(PortalControllerContext portalControllerContext) throws PortletException {
    }

    public boolean isDisplayedInAdmin() {
        return false;
    }

    public String getViewJSPName() {
        return VIEW_JSP_NAME;
    }

    public String getAdminJSPName() {
        return null;
    }
}

