/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.fragment.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.Plugin;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.services.widgets.plugin.AnnounceFolderPlayer;
import org.osivia.services.widgets.plugin.CriteriaListEditableWindow;
import org.osivia.services.widgets.plugin.DocumentUrlContainerPlayer;
import org.osivia.services.widgets.plugin.LinksEditableWindow;
import org.osivia.services.widgets.plugin.LinksFragmentModule;
import org.osivia.services.widgets.plugin.PictureBookPlayer;
import org.osivia.services.widgets.plugin.PicturebookTemplateModule;
import org.osivia.services.widgets.plugin.SliderListEditableWindow;
import org.osivia.services.widgets.plugin.SliderTemplateModule;
import org.osivia.services.widgets.plugin.SummaryFragmentModule;
import org.osivia.services.widgets.plugin.ZoomEditableWindow;
import org.osivia.services.widgets.plugin.ZoomFragmentModule;

@Plugin(value="widgets.plugin")
public class WidgetsPlugin
extends AbstractPluginPortlet {
    private static final String PLUGIN_NAME = "widgets.plugin";
    public static final String STYLE_PICTUREBOOK = "picturebook";
    public static final String SCHEMAS_PICTUREBOOK = "dublincore, common, toutatice, note, files, acaren, webcontainer, file, picture";
    public static final String LIST_TEMPLATE_SLIDER = "slider";
    public static final String LIST_TEMPLATE_SLIDER_ANNONCE = "slider-annonce";
    public static final String LIST_TEMPLATE_SLIDER_PICTURE = "slider-picture";
    public static final String SLIDER_SCHEMAS = "dublincore, toutatice, picture, annonce";
    protected IBundleFactory bundleFactory;

    public void init() throws PortletException {
        super.init();
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    protected void customizeCMSProperties(String customizationID, CustomizationContext context) {
        PortletContext portletContext = this.getPortletContext();
        Bundle bundle = this.bundleFactory.getBundle(context.getLocale());
        Map docTypes = this.getDocTypes(context);
        docTypes.put("PictureBook", new DocumentType("PictureBook", true, true, true, true, false, true, Arrays.asList("Picture", "PictureBook"), null, "glyphicons glyphicons-picture"));
        docTypes.put("Picture", new DocumentType("Picture", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-picture"));
        Map templates = this.getListTemplates(context);
        ListTemplate picturebookTemplate = new ListTemplate(STYLE_PICTUREBOOK, bundle.getString("LIST_TEMPLATE_PICTUREBOOK"), SCHEMAS_PICTUREBOOK);
        PicturebookTemplateModule picturebookModule = new PicturebookTemplateModule(portletContext);
        picturebookTemplate.setModule((IPortletModule)picturebookModule);
        templates.put(STYLE_PICTUREBOOK, picturebookTemplate);
        List players = this.getPlayers(context);
        players.add(0, new PictureBookPlayer(this.getPortletContext()));
        docTypes.put("Annonce", new DocumentType("Annonce", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-newspaper"));
        docTypes.put("AnnonceFolder", new DocumentType("AnnonceFolder", true, true, false, false, false, true, Arrays.asList("Annonce"), null, "glyphicons glyphicons-newspaper"));
        players.add(new AnnounceFolderPlayer(this.getPortletContext()));
        docTypes.put("DocumentUrlContainer", new DocumentType("DocumentUrlContainer", true, true, true, true, false, true, Arrays.asList("DocumentUrlContainer", "ContextualLink"), null, "glyphicons glyphicons-bookmark"));
        players.add(new DocumentUrlContainerPlayer(this.getPortletContext()));
        ListTemplate slider = new ListTemplate(LIST_TEMPLATE_SLIDER, bundle.getString("LIST_TEMPLATE_SLIDER"), SLIDER_SCHEMAS);
        slider.setModule((IPortletModule)new SliderTemplateModule(portletContext));
        templates.put(LIST_TEMPLATE_SLIDER, slider);
        ListTemplate sliderAnnonces = new ListTemplate(LIST_TEMPLATE_SLIDER_ANNONCE, bundle.getString("LIST_TEMPLATE_SLIDER_ANNONCE"), SLIDER_SCHEMAS);
        sliderAnnonces.setModule((IPortletModule)new SliderTemplateModule(portletContext));
        templates.put(LIST_TEMPLATE_SLIDER_ANNONCE, sliderAnnonces);
        ListTemplate sliderPicture = new ListTemplate(LIST_TEMPLATE_SLIDER_PICTURE, bundle.getString("LIST_TEMPLATE_SLIDER_PICTURE"), SLIDER_SCHEMAS);
        sliderPicture.setModule((IPortletModule)new SliderTemplateModule(portletContext));
        templates.put(LIST_TEMPLATE_SLIDER_PICTURE, sliderPicture);
        Map editableWindows = this.getEditableWindows(context);
        editableWindows.put("fgt.slider_list", new SliderListEditableWindow("toutatice-portail-cms-nuxeo-viewListPortletInstance", "slider_liste_Frag_"));
        editableWindows.put("fgt.criteria_list", new CriteriaListEditableWindow("toutatice-portail-cms-nuxeo-viewListPortletInstance", "criteria_liste_Frag_"));
        editableWindows.put("fgt.zoom", new ZoomEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "zoom_frag_"));
        List fragmentTypes = this.getFragmentTypes(context);
        fragmentTypes.add(new FragmentType("zoom_property", bundle.getString("FRAGMENT_TYPE_ZOOM"), (IFragmentModule)new ZoomFragmentModule(portletContext)));
        editableWindows.put("fgt.links", new LinksEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "links_frag_"));
        fragmentTypes.add(new FragmentType("links_property", bundle.getString("FRAGMENT_TYPE_LINKS"), (IFragmentModule)new LinksFragmentModule(portletContext)));
        fragmentTypes.add(new FragmentType("fgts_summary", bundle.getString("FRAGMENT_TYPE_SUMMARY"), (IFragmentModule)new SummaryFragmentModule(portletContext)));
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }
}

