/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import java.io.IOException;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class ZoomFragmentModule
extends FragmentModule {
    public static final String ID = "zoom_property";
    public static final String NUXEO_PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    public static final String SCOPE_WINDOW_PROPERTY = "osivia.cms.forcePublicationScope";
    public static final String REF_URI_WINDOW_PROPERTY = "osivia.refURI";
    private static final String VIEW_JSP_NAME = "zoom";
    private static final String REF_URI = "refURI";
    private static final String HREF = "href";
    private static final String CONTENT = "content";
    private static final String PICTURE = "picture";
    private static final String TEMPLATE = "zoomTemplate";

    public ZoomFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }

    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        boolean emptyContent = true;
        if (StringUtils.isNotEmpty((String)nuxeoPath)) {
            PropertyList propertyList;
            Object content;
            String refURI;
            String schema;
            NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)portletContext, (String)(nuxeoPath = nuxeoController.getComputedPath(nuxeoPath)));
            Document document = documentContext.getDoc();
            if (document.getTitle() != null) {
                response.setTitle(document.getTitle());
            }
            if (StringUtils.isNotEmpty((String)(schema = "zfgt:zoomFragment")) && StringUtils.isNotEmpty((String)(refURI = window.getProperty(REF_URI_WINDOW_PROPERTY))) && (content = document.getProperties().get(schema)) instanceof PropertyList && (propertyList = (PropertyList)content) != null && propertyList.size() > 0) {
                for (int index = 0; index < propertyList.size(); ++index) {
                    PropertyMap propertyMap = propertyList.getMap(index);
                    String refURIValue = (String)propertyMap.get(REF_URI);
                    if (!refURI.equalsIgnoreCase(refURIValue)) continue;
                    request.setAttribute("template", (Object)propertyMap.getString(TEMPLATE));
                    request.setAttribute("title", (Object)window.getProperty("osivia.title"));
                    String href = propertyMap.getString(HREF);
                    Link link = nuxeoController.getLinkFromNuxeoURL(href);
                    request.setAttribute("url", (Object)link.getUrl());
                    String imageSource = null;
                    if (StringUtils.isNotBlank((String)propertyMap.getString(PICTURE)) && StringUtils.startsWith((String)(imageSource = nuxeoController.getComputedPath(propertyMap.getString(PICTURE))), (String)"/nuxeo/")) {
                        nuxeoController.setCurrentDoc(document);
                        imageSource = nuxeoController.transformNuxeoLink(imageSource);
                    }
                    request.setAttribute("imageSource", imageSource);
                    request.setAttribute(CONTENT, (Object)nuxeoController.transformHTMLContent(StringUtils.trimToEmpty((String)propertyMap.getString(CONTENT))));
                    emptyContent = false;
                }
            }
        }
        if (emptyContent) {
            request.setAttribute("osivia.emptyResponse", (Object)"1");
        }
    }

    public String getViewJSPName() {
        return VIEW_JSP_NAME;
    }
}

