/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin.util;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.IOException;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.StreamBlob;

public class UploadFilesCommand
implements INuxeoCommand {
    private final String parentId;
    private final List<FileItem> fileItems;

    public UploadFilesCommand(String parentId, List<FileItem> fileItems) {
        this.parentId = parentId;
        this.fileItems = fileItems;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        Blobs blobs = this.getBlobsList(this.fileItems);
        OperationRequest operationRequest = nuxeoSession.newRequest("FileManager.Import").setInput((OperationInput)blobs);
        operationRequest.setContextProperty("currentDocument", (Object)this.parentId);
        return operationRequest.execute();
    }

    public Blobs getBlobsList(List<FileItem> fileItems) throws IOException {
        Blobs blobs = new Blobs();
        for (FileItem fileItem : fileItems) {
            String name = fileItem.getName();
            StreamBlob blob = new StreamBlob(fileItem.getInputStream(), name, fileItem.getContentType());
            blobs.add((Object)blob);
        }
        return blobs;
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" : ");
        builder.append(this.parentId);
        builder.append(" ; ");
        builder.append(this.fileItems);
        return builder.toString();
    }
}

