/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.delete.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.services.widgets.delete.portlet.repository.DeleteRepository;
import org.osivia.services.widgets.delete.portlet.repository.command.GetChildrenCommand;
import org.osivia.services.widgets.delete.portlet.repository.command.GetDocumentsCommand;
import org.osivia.services.widgets.delete.portlet.repository.command.GetProxiesCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class DeleteRepositoryImpl
implements DeleteRepository {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ICMSServiceLocator cmsServiceLocator;

    public Document getDocument(PortalControllerContext portalControllerContext, String path) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        return documentContext.getDocument();
    }

    public List<Document> getDocuments(PortalControllerContext portalControllerContext, String[] identifiers) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetDocumentsCommand.class, new Object[]{Arrays.asList(identifiers)});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        return documents.list();
    }

    public Map<Document, Integer> getChildrenCounts(PortalControllerContext portalControllerContext, List<Document> documents) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        ArrayList<Document> folderishDocuments = new ArrayList<Document>(documents.size());
        for (Document document : documents) {
            PropertyList facets = document.getFacets();
            if (facets.isEmpty() || !facets.list().contains("Folderish")) continue;
            folderishDocuments.add(document);
        }
        HashMap<Document, Integer> childrenCounts = new HashMap<Document, Integer>(folderishDocuments.size());
        if (CollectionUtils.isNotEmpty(folderishDocuments)) {
            INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetChildrenCommand.class, new Object[]{folderishDocuments});
            Documents children = (Documents)nuxeoController.executeNuxeoCommand(command);
            for (Document child : children) {
                Document parent = null;
                Iterator iterator = folderishDocuments.iterator();
                while (parent == null && iterator.hasNext()) {
                    Document document = (Document)iterator.next();
                    if (!StringUtils.startsWith((String)child.getPath(), (String)(document.getPath() + "/"))) continue;
                    parent = document;
                }
                if (parent == null) continue;
                Integer count = childrenCounts.getOrDefault(parent, 0);
                childrenCounts.put(parent, count + 1);
            }
        }
        return childrenCounts;
    }

    public Map<Document, Boolean> haveRemoteProxies(PortalControllerContext portalControllerContext, List<Document> documents) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        HashMap<String, Document> webIds = new HashMap<String, Document>(documents.size());
        for (Document document : documents) {
            webIds.put(document.getString("ttc:webid"), document);
        }
        HashMap<Document, Boolean> remoteProxies = new HashMap<Document, Boolean>(documents.size());
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetProxiesCommand.class, new Object[]{webIds.keySet()});
        Documents proxies = (Documents)nuxeoController.executeNuxeoCommand(command);
        for (Document proxy : proxies) {
            String proxyWebId = proxy.getString("ttc:webid");
            Document live = (Document)webIds.get(proxyWebId);
            if (live == null || StringUtils.equals((String)(live.getPath() + ".proxy"), (String)proxy.getPath())) continue;
            remoteProxies.put(live, true);
        }
        return remoteProxies;
    }

    public void delete(PortalControllerContext portalControllerContext, List<String> identifiers) throws PortletException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        for (String identifier : identifiers) {
            try {
                cmsService.putDocumentInTrash(cmsContext, identifier);
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
        }
    }
}

