/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.move.plugin.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.services.widgets.move.plugin.model.MoveMenubarModule;
import org.osivia.services.widgets.move.plugin.service.MovePluginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MovePluginServiceImpl
implements MovePluginService {
    @Autowired
    private MoveMenubarModule menubarModule;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;

    public void customizeMenubarModules(CustomizationContext customizationContext, List<MenubarModule> menubarModules) {
        menubarModules.add((MenubarModule)this.menubarModule);
    }

    public void updateMenubar(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        MenubarItem move = null;
        Iterator<MenubarItem> iterator = menubar.iterator();
        while (move == null && iterator.hasNext()) {
            MenubarItem item = iterator.next();
            if (!StringUtils.equals((String)"MOVE", (String)item.getId())) continue;
            move = item;
        }
        if (move != null) {
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            DocumentType documentType = documentContext.getDocumentType();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.move.path", documentContext.getCmsPath());
            properties.put("osivia.move.base-path", nuxeoController.getBasePath());
            properties.put("osivia.move.ignored-paths", documentContext.getCmsPath());
            if (documentType != null) {
                properties.put("osivia.move.accepted-types", documentType.getName());
            }
            String url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-widgets-move-instance", properties, PortalUrlType.MODAL);
            move.setUrl("javascript:");
            move.setHtmlClasses(null);
            Map data = move.getData();
            data.put("target", "#osivia-modal");
            data.put("load-url", url);
            data.put("title", move.getTitle());
        }
    }
}

