/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.move.portlet.configuration;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.path.IBrowserService;
import org.osivia.portal.api.portlet.PortletAppUtils;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Configuration
@ComponentScan(basePackages={"org.osivia.services.widgets.move.portlet"})
public class MoveConfiguration
extends CMSPortlet
implements PortletConfigAware {
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;

    public void setPortletConfig(PortletConfig portletConfig) {
        try {
            super.init(portletConfig);
        }
        catch (PortletException e) {
            this.log.error((Object)e.getMessage(), e.getCause());
        }
        PortletAppUtils.registerApplication((PortletConfig)portletConfig, (Object)this.applicationContext);
    }

    @Bean
    public InternalResourceViewResolver getViewResolver() {
        InternalResourceViewResolver viewResolver = new InternalResourceViewResolver();
        viewResolver.setCache(true);
        viewResolver.setViewClass(JstlView.class);
        viewResolver.setPrefix("/WEB-INF/jsp/move/");
        viewResolver.setSuffix(".jsp");
        return viewResolver;
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("move");
        return messageSource;
    }

    @Bean
    public IPortalUrlFactory getPortalUrlFactory() {
        return (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    }

    @Bean
    public ICMSServiceLocator getCmsServiceLocator() {
        return (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
    }

    @Bean
    public IBrowserService getBrowserService() {
        return (IBrowserService)Locator.findMBean(IBrowserService.class, (String)"osivia:service=BrowserService");
    }

    @Bean
    public IBundleFactory getBundleFactory() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        return internationalizationService.getBundleFactory(this.getClass().getClassLoader(), this.applicationContext);
    }

    @Bean
    public INotificationsService getNotificationsService() {
        return (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
    }
}

