/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.move.portlet.service;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.path.IBrowserService;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.services.widgets.move.portlet.model.MoveForm;
import org.osivia.services.widgets.move.portlet.model.MoveWindowProperties;
import org.osivia.services.widgets.move.portlet.repository.MoveRepository;
import org.osivia.services.widgets.move.portlet.service.MoveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class MoveServiceImpl
implements MoveService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MoveRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBrowserService browserService;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;

    public MoveForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        MoveForm form = (MoveForm)this.applicationContext.getBean(MoveForm.class);
        MoveWindowProperties windowProperties = this.getWindowProperties(portalControllerContext);
        String basePath = this.repository.getBasePath(portalControllerContext, windowProperties);
        form.setBasePath(basePath);
        String navigationPath = this.repository.getNavigationPath(portalControllerContext, windowProperties, basePath);
        form.setNavigationPath(navigationPath);
        String[] ignoredPaths = CollectionUtils.isEmpty((Collection)windowProperties.getIgnoredPaths()) ? null : windowProperties.getIgnoredPaths().toArray(new String[0]);
        form.setIgnoredPaths(ignoredPaths);
        String[] acceptedTypes = CollectionUtils.isEmpty((Collection)windowProperties.getAcceptedTypes()) ? null : windowProperties.getAcceptedTypes().toArray(new String[0]);
        form.setAcceptedTypes(acceptedTypes);
        String[] excludedTypes = new String[]{"Workspace"};
        form.setExcludedTypes(excludedTypes);
        return form;
    }

    private MoveWindowProperties getWindowProperties(PortalControllerContext portalControllerContext) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        MoveWindowProperties properties = (MoveWindowProperties)this.applicationContext.getBean(MoveWindowProperties.class);
        String path = window.getProperty("osivia.move.path");
        properties.setPath(path);
        List identifiers = this.getWindowPropertyList(window, "osivia.move.identifiers");
        properties.setIdentifiers(identifiers);
        List ignoredPaths = this.getWindowPropertyList(window, "osivia.move.ignored-paths");
        properties.setIgnoredPaths(ignoredPaths);
        String basePath = window.getProperty("osivia.move.base-path");
        properties.setBasePath(basePath);
        List acceptedTypes = this.getWindowPropertyList(window, "osivia.move.accepted-types");
        properties.setAcceptedTypes(acceptedTypes);
        String redirectionUrl = window.getProperty("osivia.move.redirection-url");
        properties.setRedirectionUrl(redirectionUrl);
        return properties;
    }

    private List<String> getWindowPropertyList(PortalWindow window, String name) {
        String value = window.getProperty(name);
        List<String> result = StringUtils.isEmpty((String)value) ? null : Arrays.asList(StringUtils.split((String)value, (String)","));
        return result;
    }

    public void move(PortalControllerContext portalControllerContext, MoveForm form) throws PortletException, IOException {
        String redirectionPath;
        List<String> identifiers;
        MoveWindowProperties windowProperties = this.getWindowProperties(portalControllerContext);
        PortletRequest request = portalControllerContext.getRequest();
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        String path = windowProperties.getPath();
        if (CollectionUtils.isEmpty((Collection)windowProperties.getIdentifiers())) {
            Document document = this.repository.getDocument(portalControllerContext, path);
            identifiers = Collections.singletonList(document.getId());
            CMSObjectPath parentPath = CMSObjectPath.parse((String)path).getParent();
            redirectionPath = parentPath.toString();
        } else {
            identifiers = windowProperties.getIdentifiers();
            redirectionPath = path;
        }
        this.repository.move(portalControllerContext, windowProperties.getBasePath(), identifiers, form.getTargetPath());
        String message = bundle.getString("MOVE_MESSAGE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        String url = StringUtils.isEmpty((String)redirectionPath) ? windowProperties.getRedirectionUrl() : this.portalUrlFactory.getCMSUrl(portalControllerContext, null, redirectionPath, null, null, "refreshPageAndNavigation", null, null, null, null);
        response.sendRedirect(url);
    }

    public String browse(PortalControllerContext portalControllerContext) throws PortletException {
        String data;
        try {
            data = this.browserService.browse(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return data;
    }
}

