/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.rename.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.io.IOException;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.widgets.rename.portlet.model.RenameForm;
import org.osivia.services.widgets.rename.portlet.repository.RenameRepository;
import org.osivia.services.widgets.rename.portlet.service.RenameService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class RenameServiceImpl
implements RenameService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RenameRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;

    public RenameForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        Document document = this.getCurrentDocument(portalControllerContext, true);
        RenameForm form = (RenameForm)this.applicationContext.getBean(RenameForm.class);
        String title = document.getTitle();
        form.setTitle(title);
        return form;
    }

    public void save(PortalControllerContext portalControllerContext, RenameForm form) throws PortletException, IOException {
        String newTitle;
        PortletRequest request = portalControllerContext.getRequest();
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        Document document = this.getCurrentDocument(portalControllerContext, false);
        String oldTitle = document.getTitle();
        if (!StringUtils.equals((String)oldTitle, (String)(newTitle = StringUtils.trim((String)form.getTitle())))) {
            this.repository.rename(portalControllerContext, document.getPath(), newTitle);
            String message = bundle.getString("RENAME_MESSAGE_SUCCESS");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        }
        this.getCurrentDocument(portalControllerContext, true);
        String redirectionPath = this.getRedirectionPath(portalControllerContext);
        String url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, redirectionPath, null, null, "refreshPageAndNavigation", null, null, null, null);
        response.sendRedirect(url);
    }

    private Document getCurrentDocument(PortalControllerContext portalControllerContext, boolean reload) throws PortletException {
        String path = this.getCurrentPath(portalControllerContext);
        NuxeoDocumentContext documentContext = this.repository.getDocumentContext(portalControllerContext, path);
        if (reload) {
            documentContext.reload();
        }
        return documentContext.getDocument();
    }

    private String getCurrentPath(PortalControllerContext portalControllerContext) {
        PortalWindow window = this.getWindow(portalControllerContext);
        return window.getProperty("osivia.rename.path");
    }

    private String getRedirectionPath(PortalControllerContext portalControllerContext) {
        PortalWindow window = this.getWindow(portalControllerContext);
        String path = window.getProperty("osivia.rename.redirection-path");
        if (StringUtils.isEmpty((String)path)) {
            path = this.getCurrentPath(portalControllerContext);
        }
        return path;
    }

    private PortalWindow getWindow(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        return WindowFactory.getWindow((PortletRequest)request);
    }
}

