/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.delete.plugin.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.services.widgets.delete.plugin.model.DeleteMenubarModule;
import org.osivia.services.widgets.delete.plugin.service.DeletePluginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeletePluginServiceImpl
implements DeletePluginService {
    @Autowired
    private DeleteMenubarModule menubarModule;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;

    public void customizeMenubarModules(CustomizationContext customizationContext, List<MenubarModule> menubarModules) {
        menubarModules.add((MenubarModule)this.menubarModule);
    }

    public void updateMenubar(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        MenubarItem delete = null;
        Iterator<MenubarItem> iterator = menubar.iterator();
        while (delete == null && iterator.hasNext()) {
            MenubarItem item = iterator.next();
            if (!StringUtils.equals((String)"DELETE", (String)item.getId())) continue;
            delete = item;
        }
        if (delete != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.delete.path", documentContext.getCmsPath());
            String url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-widgets-delete-instance", properties, PortalUrlType.MODAL);
            delete.setUrl("javascript:");
            delete.setHtmlClasses(null);
            delete.setAssociatedHTML(null);
            Map data = delete.getData();
            data.remove("fancybox");
            data.remove("src");
            data.put("target", "#osivia-modal");
            data.put("load-url", url);
            data.put("title", delete.getTitle());
        }
    }
}

