/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.portlet;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.services.wiki.services.WikiDocumentBean;
import org.osivia.portal.services.wiki.services.WikiService;
import org.osivia.portal.services.wiki.utils.WikiMode;
import org.osivia.portal.services.wiki.utils.WikiPortletAction;

public class WikiPortlet
extends CMSPortlet {
    private static final String PATH_PAGE_PUBLISHED = "/WEB-INF/jsp/wiki/view.jsp";
    private static final String PATH_PAGE_LIVE = "/WEB-INF/jsp/wiki/live.jsp";
    private static final String PATH_PAGE_EDIT = "/WEB-INF/jsp/wiki/edit.jsp";
    private static final String PATH_PAGE_ADMIN = "/WEB-INF/jsp/wiki/admin.jsp";
    private static final String PORTLET_MODE_ADMIN = "admin";
    private static final String HTML_CLASS_MENUBAR_ITEM_PUBLISHED = "portlet-menuitem-wiki published";
    private static final String HTML_CLASS_MENUBAR_ITEM_LIVE = "portlet-menuitem-wiki live";
    private static final String HTML_CLASS_MENUBAR_ITEM_EDITION = "portlet-menuitem-wiki edition fancyframe_refresh";
    private static final String HTML_CLASS_MENUBAR_ITEM_PUBLISH_ACTION = "portlet-menuitem-wiki publish-action";
    private static final String HTML_CLASS_MENUBAR_ITEM_NUXEO_LINK = "portlet-menuitem-wiki nuxeo";
    private static final String TARGET_NUXEO_LINK = "nuxeo";
    private static final String URL_SERVICE_ATTRIBUTE_NAME = "UrlService";
    private IPortalUrlFactory portalUrlFactory;
    private WikiService wikiService;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.portalUrlFactory = (IPortalUrlFactory)this.getPortletContext().getAttribute(URL_SERVICE_ATTRIBUTE_NAME);
        if (this.portalUrlFactory == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("Resource");
            throw new PortletException(resourceBundle.getString("WIKI_PORTLET_INIT_ERROR"));
        }
        this.wikiService = WikiService.getInstance();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String mode = request.getParameter("osivia.services.wiki.mode");
        String currentTitleId = request.getParameter("osivia.services.wiki.currentTitleId");
        String data = request.getParameter("osivia.services.wiki.data");
        String action = request.getParameter("osivia.services.wiki.action");
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        if (StringUtils.equals((String)WikiPortletAction.SAVE.getName(), (String)action)) {
            this.wikiService.saveLiveContent(nuxeoController, currentTitleId, data);
        } else if (StringUtils.equals((String)WikiPortletAction.PUBLISH.getName(), (String)action)) {
            this.wikiService.publishLiveContent(nuxeoController);
        }
        if (currentTitleId != null) {
            response.setRenderParameter("osivia.services.wiki.currentTitleId", currentTitleId);
        }
        response.setRenderParameter("osivia.services.wiki.mode", mode);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            WikiDocumentBean document;
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            WikiMode mode = WikiMode.fromValue((String)request.getParameter("osivia.services.wiki.mode"));
            String currentTitleId = request.getParameter("osivia.services.wiki.currentTitleId");
            try {
                document = this.wikiService.getWikiDocumentBean(nuxeoController, request, mode, currentTitleId);
            }
            catch (CMSException e) {
                document = new WikiDocumentBean();
                document.setContent("");
            }
            request.setAttribute("osivia.services.wiki.document", (Object)document);
            String requestDispatcherPath = this.fillMenubar(request, response, mode, currentTitleId, document);
            if (StringUtils.isNotBlank((String)document.getTitle())) {
                response.setTitle(document.getTitle());
            }
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(requestDispatcherPath).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private String fillMenubar(RenderRequest request, RenderResponse response, WikiMode mode, String currentTitleId, WikiDocumentBean document) throws Exception {
        PortalControllerContext portalContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        String requestDispatcherPath = PATH_PAGE_PUBLISHED;
        List menubar = (List)request.getAttribute("osivia.menuBar");
        ResourceBundle resourceBundle = ResourceBundle.getBundle("Resource", request.getLocale());
        if (document.isEditable()) {
            if (WikiMode.LIVE.equals((Object)mode)) {
                requestDispatcherPath = PATH_PAGE_LIVE;
                this.addMenubarItem(menubar, resourceBundle.getString("LIVE_VIEW"), null, HTML_CLASS_MENUBAR_ITEM_LIVE, null);
                PortletURL viewPortletUrl = response.createRenderURL();
                String viewUrl = this.portalUrlFactory.adaptPortalUrlToNavigation(portalContext, viewPortletUrl.toString());
                this.addMenubarItem(menubar, resourceBundle.getString("GO_TO_PUBLISHED_VIEW"), viewUrl, HTML_CLASS_MENUBAR_ITEM_PUBLISHED, null);
                PortletURL editPortletUrl = response.createRenderURL();
                editPortletUrl.setParameter("osivia.services.wiki.mode", WikiMode.EDITION.getValue());
                String editUrl = this.portalUrlFactory.adaptPortalUrlToPopup(portalContext, editPortletUrl.toString(), 0);
                this.addMenubarItem(menubar, resourceBundle.getString("EDITION"), editUrl, HTML_CLASS_MENUBAR_ITEM_EDITION, null);
                PortletURL publishActionPortletUrl = response.createActionURL();
                publishActionPortletUrl.setParameter("osivia.services.wiki.mode", WikiMode.PUBLISHED.getValue());
                publishActionPortletUrl.setParameter("osivia.services.wiki.action", WikiPortletAction.PUBLISH.getName());
                String publishActionUrl = this.portalUrlFactory.adaptPortalUrlToNavigation(portalContext, publishActionPortletUrl.toString());
                this.addMenubarItem(menubar, resourceBundle.getString("PUBLISH_ACTION"), publishActionUrl, HTML_CLASS_MENUBAR_ITEM_PUBLISH_ACTION, null);
                String nuxeoUrl = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + document.getLiveId() + "/view_documents";
                this.addMenubarItem(menubar, resourceBundle.getString("NUXEO_LINK"), nuxeoUrl, HTML_CLASS_MENUBAR_ITEM_NUXEO_LINK, TARGET_NUXEO_LINK);
            } else if (WikiMode.EDITION.equals((Object)mode)) {
                requestDispatcherPath = PATH_PAGE_EDIT;
                PortletURL livePortletUrl = response.createActionURL();
                livePortletUrl.setParameter("osivia.services.wiki.mode", WikiMode.LIVE.getValue());
                if (currentTitleId != null) {
                    livePortletUrl.setParameter("osivia.services.wiki.currentTitleId", currentTitleId);
                }
                livePortletUrl.setParameter("osivia.services.wiki.action", WikiPortletAction.SAVE.getName());
                String liveUrl = this.portalUrlFactory.adaptPortalUrlToPopup(portalContext, livePortletUrl.toString(), 1);
                request.setAttribute("osivia.services.wiki.liveUrl", (Object)liveUrl);
                PortletURL saveEditionPortletUrl = response.createActionURL();
                saveEditionPortletUrl.setParameter("osivia.services.wiki.mode", WikiMode.EDITION.getValue());
                if (currentTitleId != null) {
                    saveEditionPortletUrl.setParameter("osivia.services.wiki.currentTitleId", currentTitleId);
                }
                saveEditionPortletUrl.setParameter("osivia.services.wiki.action", WikiPortletAction.SAVE.getName());
                request.setAttribute("osivia.services.wiki.editUrl", (Object)saveEditionPortletUrl.toString());
                PortletURL callbackPortletUrl = response.createRenderURL();
                callbackPortletUrl.setParameter("osivia.services.wiki.mode", WikiMode.LIVE.getValue());
                String callbackUrl = this.portalUrlFactory.adaptPortalUrlToPopup(portalContext, callbackPortletUrl.toString(), 2);
                request.setAttribute("osivia.popupCallbackUrl", (Object)callbackUrl);
            } else {
                this.addMenubarItem(menubar, resourceBundle.getString("PUBLISHED_VIEW"), null, HTML_CLASS_MENUBAR_ITEM_PUBLISHED, null);
                PortletURL livePortletUrl = response.createRenderURL();
                livePortletUrl.setParameter("osivia.services.wiki.mode", WikiMode.LIVE.getValue());
                String liveUrl = this.portalUrlFactory.adaptPortalUrlToNavigation(portalContext, livePortletUrl.toString());
                this.addMenubarItem(menubar, resourceBundle.getString("GO_TO_LIVE_VIEW"), liveUrl, HTML_CLASS_MENUBAR_ITEM_LIVE, null);
            }
        }
        return requestDispatcherPath;
    }

    private void addMenubarItem(List<MenubarItem> menubar, String title, String url, String htmlClass, String target) {
        MenubarItem menubarItem = new MenubarItem(null, title, MenubarItem.ORDER_PORTLET_SPECIFIC, url, null, htmlClass, target);
        menubarItem.setAjaxDisabled(true);
        menubar.add(menubarItem);
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_PAGE_ADMIN).include(request, response);
    }
}

