/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.jaxrs.model.DocRef;
import org.osivia.portal.services.wiki.services.WikiDocumentBean;

public class DocumentUpdateCommand
implements INuxeoCommand {
    private final WikiDocumentBean document;

    public DocumentUpdateCommand(WikiDocumentBean document) {
        this.document = document;
    }

    public Object execute(Session session) throws Exception {
        DocumentService rs = (DocumentService)session.getAdapter(DocumentService.class);
        DocRef docRef = new DocRef(this.document.getPath());
        if (StringUtils.isNotBlank((String)this.document.getTitle())) {
            rs.setProperty(docRef, "dc:title", this.document.getTitle());
        }
        if (StringUtils.isNotBlank((String)this.document.getWebUrl())) {
            rs.setProperty(docRef, "webc:url", this.document.getWebUrl());
        }
        if (this.document.isWikiBook()) {
            rs.setProperty(docRef, "wikibook:resume", this.document.getContent());
        } else {
            rs.setProperty(docRef, "wikisection:data", this.document.getContent());
        }
        return null;
    }

    public String getId() {
        return "DocumentUpdateCommand/" + this.document.getPath();
    }
}

