/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.cyberneko.html.parsers.DOMParser;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.HTMLWriter;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.services.wiki.services.DocumentUpdateCommand;
import org.osivia.portal.services.wiki.services.WikiDocumentBean;
import org.osivia.portal.services.wiki.services.generators.WikiContentGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiSummaryGenerator;
import org.osivia.portal.services.wiki.utils.WikiMode;
import org.osivia.portal.services.wiki.utils.WikiUtils;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class WikiService {
    private static final Pattern TITLE_PATTERN = Pattern.compile("[^\\\\]*<h1[ ]*(id=['\"](.+)['\"])?.*>(.+)</h1>.*", 2);
    private static final int REGEX_GROUP_TITLE_ID = 2;
    private static final int REGEX_GROUP_TITLE_CONTENT = 3;
    private static final Pattern CODE_PATTERN = Pattern.compile(".*((<code>)|(</code>)).*", 2);
    private static final int REGEX_GROUP_BEGIN_CODE = 2;
    private static final int REGEX_GROUP_END_CODE = 3;
    private static WikiService instance;

    private WikiService() {
    }

    public static WikiService getInstance() {
        if (instance == null) {
            instance = new WikiService();
        }
        return instance;
    }

    public WikiDocumentBean getWikiDocumentBean(NuxeoController nuxeoController, RenderRequest request, WikiMode mode, String currentTitleId) throws Exception {
        String data;
        WikiDocumentBean wikiDocumentBean = new WikiDocumentBean();
        String path = nuxeoController.getItemNavigationPath();
        wikiDocumentBean.setPath(path);
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        CMSPublicationInfos cmsPublicationInfos = NuxeoController.getCMSService().getPublicationInfos(cmsContext, path);
        boolean editable = cmsPublicationInfos.isEditableByUser();
        wikiDocumentBean.setEditable(editable);
        String liveId = cmsPublicationInfos.getLiveId();
        wikiDocumentBean.setLiveId(liveId);
        nuxeoController.setDisplayLiveVersion(mode.getNuxeoDisplayLiveVersion());
        Document document = nuxeoController.fetchDocument(path);
        String title = document.getTitle();
        wikiDocumentBean.setTitle(title);
        String webUrl = document.getProperties().getString("webc:url");
        wikiDocumentBean.setWebUrl(webUrl);
        String type = document.getType();
        boolean wikiBook = StringUtils.equals((String)"WikiBook", (String)type);
        wikiDocumentBean.setWikiBook(wikiBook);
        String displayContent = "";
        String summary = null;
        if (wikiBook) {
            data = document.getProperties().getString("wikibook:resume");
            summary = this.generateWikiBookSummaryHtmlData(nuxeoController);
        } else {
            data = document.getProperties().getString("wikisection:data");
        }
        if (StringUtils.isNotEmpty((String)data)) {
            if (WikiMode.EDITION.equals((Object)mode)) {
                if (currentTitleId != null) {
                    String[] splitData = this.splitWikiData(nuxeoController, data, currentTitleId);
                    displayContent = splitData[1];
                } else {
                    displayContent = data;
                }
            } else {
                Node rootNode = this.parseWikiContent(data);
                displayContent = this.generateWikiContentHtmlData(nuxeoController, rootNode);
                if (!wikiBook) {
                    summary = this.generateWikiSummaryHtmlData(nuxeoController, rootNode);
                }
            }
        }
        wikiDocumentBean.setContent(displayContent);
        wikiDocumentBean.setSummary(summary);
        return wikiDocumentBean;
    }

    public String[] splitWikiData(NuxeoController nuxeoController, String data, String currentTitleId) {
        int status = 0;
        StringBuffer before = new StringBuffer();
        StringBuffer current = new StringBuffer();
        StringBuffer after = new StringBuffer();
        StringBuffer[] buffers = new StringBuffer[]{before, current, after};
        boolean code = false;
        String[] lines = StringUtils.splitPreserveAllTokens((String)data, (String)SystemUtils.LINE_SEPARATOR);
        for (int i = 0; i < lines.length; ++i) {
            String line = StringUtils.chomp((String)lines[i]);
            boolean lastLine = i == lines.length - 1;
            code = this.splitWikiDataCodeHandling(code, line);
            status = this.splitWikiDataLineHandling(nuxeoController, currentTitleId, buffers, status, line, code, lastLine);
        }
        return new String[]{before.toString(), current.toString(), after.toString()};
    }

    private boolean splitWikiDataCodeHandling(boolean code, String line) {
        boolean newCode = code;
        Matcher codeMatcher = CODE_PATTERN.matcher(line);
        if (codeMatcher.matches()) {
            if (codeMatcher.group(2) != null) {
                newCode = true;
            }
            if (codeMatcher.group(3) != null) {
                newCode = false;
            }
        }
        return newCode;
    }

    private int splitWikiDataLineHandling(NuxeoController nuxeoController, String currentTitleId, StringBuffer[] buffers, int status, String line, boolean code, boolean lastLine) {
        Matcher matcher;
        int newStatus = status;
        String newLine = line;
        if (!code && (matcher = TITLE_PATTERN.matcher(line)).matches()) {
            String id = matcher.group(2);
            if (id == null) {
                id = WikiUtils.generateUniqueTitleAnchor((NuxeoController)nuxeoController, (String)matcher.group(3));
            }
            if (StringUtils.equals((String)currentTitleId, (String)id) || newStatus == 1) {
                ++newStatus;
            }
        }
        if (!lastLine) {
            newLine = newLine + SystemUtils.LINE_SEPARATOR;
        }
        buffers[newStatus].append(newLine);
        return newStatus;
    }

    public Node parseWikiContent(String wikiContent) throws IOException, SAXException {
        String protectedWikiContent = this.codeTagsProtection(wikiContent);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(protectedWikiContent.getBytes("UTF-8"));
        InputSource inputSource = new InputSource(inputStream);
        DOMParser parser = new DOMParser();
        parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)"UTF-8");
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        parser.parse(inputSource);
        return parser.getDocument();
    }

    private String codeTagsProtection(String wikiContent) {
        String startTag = "<code>";
        String endTag = "</code>";
        ArrayList<String> result = new ArrayList<String>();
        String[] startSplit = wikiContent.split("(?i)" + startTag);
        String content = startSplit[0].replaceAll("\\\\<", "&amp;lt;");
        result.add(content);
        for (int i = 1; i < startSplit.length; ++i) {
            String[] endSplit = startSplit[i].split("(?i)" + endTag);
            result.add(startTag);
            String codeContent = endSplit[0].replaceAll("<", "&amp;lt;");
            result.add(codeContent);
            result.add(endTag);
            for (int j = 1; j < endSplit.length; ++j) {
                content = endSplit[j].replaceAll("\\\\<", "&amp;lt;");
                result.add(content);
            }
        }
        return StringUtils.join(result, null);
    }

    public String generateWikiContentHtmlData(NuxeoController nuxeoController, Node node) throws IOException {
        Element element = WikiContentGenerator.getInstance().dom4jGeneration(nuxeoController, node);
        return this.writeHtmlData(element);
    }

    public String generateWikiSummaryHtmlData(NuxeoController nuxeoController, Node node) throws IOException {
        Element element = WikiSummaryGenerator.getInstance().dom4jGeneration(nuxeoController, node);
        if ("&nbsp;".equals(element.getText())) {
            return null;
        }
        return this.writeHtmlData(element);
    }

    public String generateWikiBookSummaryHtmlData(NuxeoController nuxeoController) throws Exception {
        Element ul = this.recursiveWikiBookSummaryGeneration(nuxeoController, null);
        String htmlData = null;
        if (ul != null) {
            htmlData = this.writeHtmlData(ul);
        }
        return htmlData;
    }

    private Element recursiveWikiBookSummaryGeneration(NuxeoController nuxeoController, CMSItem item) throws Exception {
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        String spacePath = nuxeoController.getSpacePath();
        String path = item == null ? nuxeoController.getItemNavigationPath() : item.getPath();
        DOMElement ulParent = null;
        List subItems = NuxeoController.getCMSService().getPortalNavigationSubitems(cmsContext, spacePath, path);
        if (CollectionUtils.isNotEmpty((Collection)subItems)) {
            ulParent = new DOMElement(QName.get((String)"ul"));
            for (CMSItem subItem : subItems) {
                Document document = (Document)subItem.getNativeItem();
                Link link = nuxeoController.getLink(document);
                String url = link.getUrl();
                String title = document.getTitle();
                DOMElement li = new DOMElement(QName.get((String)"li"));
                ulParent.add((Element)li);
                DOMElement a = new DOMElement(QName.get((String)"a"));
                a.addAttribute(QName.get((String)"href"), url);
                a.setText(title);
                li.add((Element)a);
                Element ulChildren = this.recursiveWikiBookSummaryGeneration(nuxeoController, subItem);
                if (ulChildren == null) continue;
                li.add(ulChildren);
            }
        }
        return ulParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeHtmlData(Element htmlElement) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
        HTMLWriter htmlWriter = null;
        String resultat = null;
        try {
            htmlWriter = new HTMLWriter((OutputStream)bufferedOutput);
            htmlWriter.setEscapeText(false);
            try {
                htmlWriter.write(htmlElement);
            }
            finally {
                htmlWriter.close();
            }
            resultat = output.toString("UTF-8");
        }
        finally {
            ((OutputStream)bufferedOutput).close();
            output.close();
        }
        return resultat;
    }

    public void saveLiveContent(NuxeoController nuxeoController, String currentTitleId, String data) throws PortletException {
        String managedData = data;
        String contentPath = nuxeoController.getItemNavigationPath();
        boolean wikiBook = false;
        try {
            nuxeoController.setDisplayLiveVersion(WikiMode.LIVE.getNuxeoDisplayLiveVersion());
            Document nuxeoDocument = nuxeoController.fetchDocument(contentPath);
            String type = nuxeoDocument.getType();
            wikiBook = StringUtils.equals((String)"WikiBook", (String)type);
            if (currentTitleId != null) {
                String previousVersionData = wikiBook ? nuxeoDocument.getProperties().getString("wikibook:resume") : nuxeoDocument.getProperties().getString("wikisection:data");
                String[] splitData = this.splitWikiData(nuxeoController, previousVersionData, currentTitleId);
                managedData = splitData[0] + managedData + splitData[2];
            }
            WikiDocumentBean wikiDocument = new WikiDocumentBean(contentPath, managedData, wikiBook);
            DocumentUpdateCommand command = new DocumentUpdateCommand(wikiDocument);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            nuxeoController.setDisplayLiveVersion("1");
            nuxeoController.fetchDocument(contentPath, true);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void publishLiveContent(NuxeoController nuxeoController) throws PortletException {
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        String path = nuxeoController.getItemNavigationPath();
        try {
            NuxeoController.getCMSService().publishDocument(cmsContext, path);
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }
}

