/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.generators;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.osivia.portal.services.wiki.services.generators.IWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiContentGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiTableTypes;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class TableWikiGenerator
extends WikiContentGenerator
implements IWikiGenerator {
    private static TableWikiGenerator instance;

    private TableWikiGenerator() {
    }

    public static synchronized TableWikiGenerator getInstance() {
        if (instance == null) {
            instance = new TableWikiGenerator();
        }
        return instance;
    }

    public Element generate(NuxeoController nuxeoController, Node node, Element parent, Element root) {
        WikiTableTypes type = WikiTableTypes.getWikiTableType((String)node.getNodeName());
        if (type != null) {
            NamedNodeMap attributes = node.getAttributes();
            Node classNode = attributes.getNamedItem("class");
            DOMElement tableElement = new DOMElement(QName.get((String)"div"));
            this.addTableClass(type, classNode, (Element)tableElement);
            boolean hasContent = this.addTableChildren(nuxeoController, node, root, type, (Element)tableElement);
            if (hasContent) {
                if (type.isRoot()) {
                    root.add((Element)tableElement);
                    return null;
                }
                return tableElement;
            }
        }
        return null;
    }

    private void addTableClass(WikiTableTypes type, Node classNode, Element tableElement) {
        String htmlClass = type.getHtmlClass();
        if (classNode != null && 2 == classNode.getNodeType()) {
            htmlClass = htmlClass + " " + classNode.getTextContent();
        }
        tableElement.addAttribute(QName.get((String)"class"), htmlClass);
    }

    private boolean addTableChildren(NuxeoController nuxeoController, Node node, Element root, WikiTableTypes type, Element tableElement) {
        boolean hasContent = false;
        if (type.isCell()) {
            if (node.hasChildNodes() && StringUtils.isNotBlank((String)node.getTextContent())) {
                this.childrenHandling(nuxeoController, node, tableElement, root);
            } else {
                tableElement.setText("&nbsp;");
            }
            hasContent = true;
        } else {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                Element tableChildElement;
                if (1 != child.getNodeType() || (tableChildElement = this.generate(nuxeoController, child, tableElement, root)) == null) continue;
                tableElement.add(tableChildElement);
                hasContent = true;
            }
        }
        return hasContent;
    }
}

