/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.generators;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.Locale;
import javax.portlet.PortletURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.services.wiki.services.generators.IWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiContentGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiTitleTypes;
import org.osivia.portal.services.wiki.utils.WikiUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TitleWikiGenerator
extends WikiContentGenerator
implements IWikiGenerator {
    private static final Log LOGGER = LogFactory.getLog(TitleWikiGenerator.class);
    private static final String HTML_CLASS_FANCYFRAME_REFRESH = "fancyframe_refresh";
    private static TitleWikiGenerator instance;

    private TitleWikiGenerator() {
    }

    public static synchronized TitleWikiGenerator getInstance() {
        if (instance == null) {
            instance = new TitleWikiGenerator();
        }
        return instance;
    }

    public Element generate(NuxeoController nuxeoController, Node node, Element parent, Element root) {
        WikiTitleTypes type = WikiTitleTypes.getWikiTitleType((String)node.getNodeName());
        if (type != null) {
            DOMElement title;
            block5: {
                title = new DOMElement(type.getQName());
                NamedNodeMap attributes = node.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                String idTitle = idAttribute != null && 2 == idAttribute.getNodeType() ? idAttribute.getTextContent() : WikiUtils.generateUniqueTitleAnchor((NuxeoController)nuxeoController, (String)node.getTextContent());
                title.addAttribute(QName.get((String)"id"), idTitle);
                this.childrenHandling(nuxeoController, node, (Element)title, root);
                IContributionService.EditionState editionState = TitleWikiGenerator.getContributionService().getEditionState(nuxeoController.getPortalCtx());
                if (type.getLevel() == 1 && editionState != null && IContributionService.EditionState.CONTRIBUTION_MODE_EDITION.equals(editionState)) {
                    try {
                        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
                        String path = nuxeoController.getItemNavigationPath();
                        CMSPublicationInfos cmsPublicationInfos = NuxeoController.getCMSService().getPublicationInfos(cmsContext, path);
                        if (cmsPublicationInfos.isEditableByUser()) {
                            Locale locale = cmsContext.getRequest().getLocale();
                            DOMElement link = new DOMElement(QName.get((String)"a"));
                            link.addAttribute(QName.get((String)"class"), "fancyframe_refresh");
                            PortletURL editPortletUrl = cmsContext.getResponse().createRenderURL();
                            editPortletUrl.setParameter("osivia.services.wiki.mode", String.valueOf(true));
                            editPortletUrl.setParameter("osivia.services.wiki.currentTitleId", idTitle);
                            String editUrl = nuxeoController.getPortalUrlFactory().adaptPortalUrlToPopup(nuxeoController.getPortalCtx(), editPortletUrl.toString(), 0);
                            link.addAttribute(QName.get((String)"href"), editUrl);
                            Bundle bundle = TitleWikiGenerator.getBundleFactory().getBundle(locale);
                            String edition = bundle.getString("EDITION");
                            String text = "[" + edition + "]";
                            link.setText(text);
                            title.addText(" ");
                            title.add((Element)link);
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) break block5;
                        LOGGER.debug((Object)e.getMessage(), e.getCause());
                    }
                }
            }
            root.add((Element)title);
        }
        return null;
    }
}

