/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.services.wiki.services.WikiDocumentBean;

public class DocumentUpdateCommand
implements INuxeoCommand {
    private final WikiDocumentBean document;

    public DocumentUpdateCommand(WikiDocumentBean document) {
        this.document = document;
    }

    public Object execute(Session session) throws CMSException {
        DocumentService rs = (DocumentService)session.getAdapter(DocumentService.class);
        DocRef docRef = new DocRef(this.document.getPath());
        try {
            if (StringUtils.isNotBlank((String)this.document.getTitle())) {
                rs.setProperty(docRef, "dc:title", this.document.getTitle());
            }
            if (this.document.isWikiBook()) {
                rs.setProperty(docRef, "wikibook:resume", this.document.getContent());
            } else {
                rs.setProperty(docRef, "wikisection:data", this.document.getContent());
            }
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        return null;
    }

    public String getId() {
        return "DocumentUpdateCommand/" + this.document.getPath();
    }
}

