/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.generators;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.web.IWebIdService;
import org.osivia.portal.services.wiki.services.generators.IWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiContentGenerator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class LinkWikiGenerator
extends WikiContentGenerator
implements IWikiGenerator {
    private static LinkWikiGenerator instance;

    private LinkWikiGenerator() {
    }

    public static synchronized LinkWikiGenerator getInstance() {
        if (instance == null) {
            instance = new LinkWikiGenerator();
        }
        return instance;
    }

    public Element generate(NuxeoController nuxeoController, Node node, Element parent, Element root) {
        NamedNodeMap attributes;
        Node hrefAttribute;
        Element newParent = parent;
        if (newParent == null) {
            newParent = this.createNewParagraph(root);
        }
        DOMElement link = new DOMElement(QName.get((String)"a"));
        String href = "";
        if (node.hasAttributes() && (hrefAttribute = (attributes = node.getAttributes()).getNamedItem("href")) != null && 2 == hrefAttribute.getNodeType()) {
            href = hrefAttribute.getTextContent();
            if (StringUtils.startsWithIgnoreCase((String)href, (String)"wiki:")) {
                try {
                    CMSItem targetItem = this.getWebItem(nuxeoController, href);
                    IWebIdService webIdService = nuxeoController.getWebIdService();
                    href = nuxeoController.getCMSLinkByPath(webIdService.itemToPageUrl(nuxeoController.getCMSCtx(), targetItem), null).getUrl();
                }
                catch (Exception e) {
                    href = "#";
                }
            } else if (!StringUtils.startsWith((String)href, (String)"#")) {
                Node targetAttribute = attributes.getNamedItem("target");
                if (targetAttribute != null && 2 == targetAttribute.getNodeType()) {
                    link.addAttribute(QName.get((String)"target"), targetAttribute.getTextContent());
                } else {
                    link.addAttribute(QName.get((String)"target"), "_blank");
                }
            }
            link.addAttribute(QName.get((String)"class"), "no-ajax-link");
            link.addAttribute(QName.get((String)"href"), href);
        }
        if (StringUtils.isBlank((String)node.getTextContent())) {
            link.setText(href);
        } else {
            this.childrenHandling(nuxeoController, node, (Element)link, root);
        }
        newParent.add((Element)link);
        return newParent;
    }

    public CMSItem getWebItem(NuxeoController nuxeoController, String href) {
        Document doc = nuxeoController.getCurrentDoc();
        String domainId = doc.getString("ttc:domainID");
        String webid = StringUtils.removeStart((String)href, (String)"wiki:");
        return new CMSItem(null, domainId, webid, null, null);
    }
}

