/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.generators;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.osivia.portal.services.wiki.services.generators.IWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiContentGenerator;
import org.w3c.dom.Node;

public final class ListWikiGenerator
extends WikiContentGenerator
implements IWikiGenerator {
    private static ListWikiGenerator ulInstance;
    private static ListWikiGenerator olInstance;
    private final QName qName;

    private ListWikiGenerator(QName qName) {
        this.qName = qName;
    }

    public static synchronized ListWikiGenerator getUlInstance() {
        if (ulInstance == null) {
            ulInstance = new ListWikiGenerator(QName.get((String)"ul"));
        }
        return ulInstance;
    }

    public static synchronized ListWikiGenerator getOlInstance() {
        if (olInstance == null) {
            olInstance = new ListWikiGenerator(QName.get((String)"ol"));
        }
        return olInstance;
    }

    public Element generate(NuxeoController nuxeoController, Node node, Element parent, Element root) {
        if (node.hasChildNodes()) {
            DOMElement listRoot = new DOMElement(this.qName);
            root.add((Element)listRoot);
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (1 != child.getNodeType() || !StringUtils.equalsIgnoreCase((String)"li", (String)child.getNodeName())) continue;
                DOMElement listNode = new DOMElement(QName.get((String)"li"));
                listRoot.add((Element)listNode);
                this.childrenHandling(nuxeoController, child, (Element)listNode, root);
            }
        }
        return null;
    }
}

