/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.services.generators;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.osivia.portal.services.wiki.services.generators.IWikiGenerator;
import org.osivia.portal.services.wiki.services.generators.WikiContentGenerator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class NoteWikiGenerator
extends WikiContentGenerator
implements IWikiGenerator {
    private static final String HTML_CLASS_NOTE = "wiki-note";
    private static final String HTML_CLASS_NOTE_DEFAULT = "note";
    private static final String HTML_CLASS_NOTE_TABLE = "wiki-table";
    private static final String HTML_CLASS_NOTE_ROW = "wiki-table-row";
    private static final String HTML_CLASS_NOTE_FIRST_CELL = "wiki-note-icon wiki-table-cell";
    private static final String HTML_CLASS_NOTE_SECOND_CELL = "wiki-table-cell";
    private static NoteWikiGenerator instance;

    private NoteWikiGenerator() {
    }

    public static synchronized NoteWikiGenerator getInstance() {
        if (instance == null) {
            instance = new NoteWikiGenerator();
        }
        return instance;
    }

    public Element generate(NuxeoController nuxeoController, Node node, Element parent, Element root) {
        NamedNodeMap attributes;
        Node typeNode;
        DOMElement note = new DOMElement(QName.get((String)"div"));
        note.addAttribute(QName.get((String)"class"), HTML_CLASS_NOTE);
        DOMElement div = new DOMElement(QName.get((String)"div"));
        note.add((Element)div);
        DOMElement table = new DOMElement(QName.get((String)"div"));
        table.addAttribute(QName.get((String)"class"), HTML_CLASS_NOTE_TABLE);
        div.add((Element)table);
        DOMElement row = new DOMElement(QName.get((String)"div"));
        row.addAttribute(QName.get((String)"class"), HTML_CLASS_NOTE_ROW);
        table.add((Element)row);
        DOMElement icon = new DOMElement(QName.get((String)"div"));
        icon.addAttribute(QName.get((String)"class"), HTML_CLASS_NOTE_FIRST_CELL);
        icon.setText("");
        row.add((Element)icon);
        DOMElement content = new DOMElement(QName.get((String)"div"));
        content.addAttribute(QName.get((String)"class"), HTML_CLASS_NOTE_SECOND_CELL);
        row.add((Element)content);
        String htmlClass = null;
        if (node.hasAttributes() && (typeNode = (attributes = node.getAttributes()).getNamedItem("class")) != null && 2 == typeNode.getNodeType()) {
            htmlClass = typeNode.getTextContent();
        }
        if (StringUtils.isBlank(htmlClass)) {
            htmlClass = HTML_CLASS_NOTE_DEFAULT;
        }
        div.addAttribute(QName.get((String)"class"), htmlClass);
        this.childrenHandling(nuxeoController, node, (Element)content, root);
        root.add((Element)note);
        return null;
    }
}

