/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.wiki.portlet;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.services.wiki.services.WikiDocumentBean;
import org.osivia.portal.services.wiki.services.WikiService;

public class WikiPortlet
extends CMSPortlet {
    private static final String PATH_PAGE_PUBLISHED = "/WEB-INF/jsp/wiki/view.jsp";
    private static final String PATH_PAGE_EDIT = "/WEB-INF/jsp/wiki/edit.jsp";
    private static final String PATH_PAGE_ADMIN = "/WEB-INF/jsp/wiki/admin.jsp";
    private static final String PORTLET_MODE_ADMIN = "admin";
    private IBundleFactory bundleFactory;
    private IPortalUrlFactory portalUrlFactory;
    private IContributionService contributionService;
    private WikiService wikiService;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        IInternationalizationService internationalizationService = (IInternationalizationService)this.getPortletContext().getAttribute("InternationalizationService");
        if (internationalizationService == null) {
            throw new PortletException("Internationalization service initialization error.");
        }
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        Bundle defaultBundle = this.bundleFactory.getBundle(Locale.getDefault());
        if (this.getPortletContext().getAttribute("NotificationsService") == null) {
            throw new PortletException(defaultBundle.getString("MESSAGE_WIKI_PORTLET_INIT_ERROR", new Object[]{"NotificationsService"}));
        }
        this.portalUrlFactory = (IPortalUrlFactory)this.getPortletContext().getAttribute("UrlService");
        if (this.portalUrlFactory == null) {
            throw new PortletException(defaultBundle.getString("MESSAGE_WIKI_PORTLET_INIT_ERROR", new Object[]{"UrlService"}));
        }
        this.contributionService = (IContributionService)this.getPortletContext().getAttribute("ContributionService");
        if (this.contributionService == null) {
            throw new PortletException(defaultBundle.getString("MESSAGE_WIKI_PORTLET_INIT_ERROR", new Object[]{"ContributionService"}));
        }
        this.wikiService = WikiService.getInstance((PortletContext)this.getPortletContext());
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String action = request.getParameter("javax.portlet.action");
        if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            if ("save".equals(action)) {
                NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                String currentTitleId = request.getParameter("currentTitleId");
                String data = request.getParameter("data");
                if (request.getParameter("save") != null) {
                    this.wikiService.saveLiveContent(nuxeoController, currentTitleId, data);
                    response.setRenderParameter("osivia.services.wiki.mode", String.valueOf(true));
                } else if (request.getParameter("validate") != null) {
                    this.wikiService.saveLiveContent(nuxeoController, currentTitleId, data);
                    request.setAttribute("osivia.closePopup", (Object)"true");
                }
                if (currentTitleId != null) {
                    response.setRenderParameter("currentTitleId", currentTitleId);
                }
            } else {
                this.processCommentAction(request, response);
            }
        } else if (PORTLET_MODE_ADMIN.equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String path = request.getParameter("nuxeoPath");
                if (StringUtils.isBlank((String)path)) {
                    path = null;
                }
                window.setProperty("osivia.cms.uri", path);
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            WikiDocumentBean wiki;
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            boolean edition = Boolean.parseBoolean(request.getParameter("osivia.services.wiki.mode"));
            String currentTitleId = request.getParameter("currentTitleId");
            request.setAttribute("currentTitleId", (Object)currentTitleId);
            try {
                wiki = this.wikiService.getWikiDocumentBean(nuxeoController, edition, currentTitleId);
            }
            catch (CMSException e) {
                wiki = new WikiDocumentBean();
                wiki.setContent("");
            }
            request.setAttribute("wiki", (Object)wiki);
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            request.setAttribute("osivia.portal.internationalization.bundle", (Object)bundle);
            String requestDispatcherPath = this.fillMenubar(nuxeoController, request, response, bundle, edition, wiki);
            if (StringUtils.isNotBlank((String)wiki.getTitle())) {
                response.setTitle(wiki.getTitle());
            }
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(requestDispatcherPath).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private String fillMenubar(NuxeoController nuxeoController, RenderRequest request, RenderResponse response, Bundle bundle, boolean edition, WikiDocumentBean document) throws PortletException {
        PortalControllerContext portalContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        String requestDispatcherPath = PATH_PAGE_PUBLISHED;
        try {
            IContributionService.EditionState editionState;
            List menubar = (List)request.getAttribute("osivia.menuBar");
            for (MenubarItem menubarItem : menubar) {
                if (!"EDIT".equals(menubarItem.getId())) continue;
                PortletURL editPortletUrl = response.createRenderURL();
                editPortletUrl.setParameter("osivia.services.wiki.mode", String.valueOf(true));
                PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
                String pathProperty = window.getProperty("osivia.cms.uri");
                editPortletUrl.setParameter("osivia.cms.editionPath", NuxeoController.getLivePath((String)pathProperty));
                String editUrl = this.portalUrlFactory.adaptPortalUrlToPopup(portalContext, editPortletUrl.toString(), 0);
                menubarItem.setUrl(editUrl);
                menubarItem.setOnclick(null);
            }
            if (document.isEditable() && (editionState = this.contributionService.getEditionState(portalContext)) != null && IContributionService.EditionState.CONTRIBUTION_MODE_EDITION.equals(editionState.getContributionMode())) {
                if (edition) {
                    requestDispatcherPath = PATH_PAGE_EDIT;
                }
                PortletURL callbackPortletUrl = response.createRenderURL();
                String callbackUrl = this.portalUrlFactory.adaptPortalUrlToPopup(portalContext, callbackPortletUrl.toString(), 2);
                request.setAttribute("osivia.popupCallbackUrl", (Object)callbackUrl);
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return requestDispatcherPath;
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        if (nuxeoPath == null) {
            nuxeoPath = "";
        }
        request.setAttribute("nuxeoPath", (Object)nuxeoPath);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_PAGE_ADMIN).include(request, response);
    }
}

