/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.comments;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.ThreadPostDTO;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class AddCommentCommand
implements INuxeoCommand {
    private final Document document;
    private final CommentDTO comment;
    private final String parentId;

    public AddCommentCommand(Document document, CommentDTO comment, String parentId) {
        this.document = document;
        this.comment = comment;
        this.parentId = parentId;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request;
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        String title = null;
        File attachment = null;
        String filename = null;
        if (this.comment instanceof ThreadPostDTO) {
            ThreadPostDTO threadPost = (ThreadPostDTO)this.comment;
            title = threadPost.getTitle();
            attachment = threadPost.getAttachment();
            filename = threadPost.getFilename();
        }
        if (StringUtils.isBlank((String)this.parentId)) {
            request = nuxeoSession.newRequest("Document.AddComment");
            request.set("comment", (Object)this.comment.getContent());
            if (title != null) {
                request.set("title", (Object)title);
            }
        } else {
            request = nuxeoSession.newRequest("Document.CreateChildComment");
            request.set("comment", (Object)this.parentId);
            request.set("childComment", (Object)this.comment.getContent());
            if (title != null) {
                request.set("childCommentTitle", (Object)title);
            }
        }
        request.set("commentableDoc", (Object)this.document.getId());
        File tmpFile = null;
        if (attachment != null) {
            request.set("fileName", (Object)filename);
            request.setInput((OperationInput)new FileBlob(attachment));
        } else {
            tmpFile = File.createTempFile("tmp_com", ".tmp");
            request.setInput((OperationInput)new FileBlob(tmpFile));
        }
        Blob blob = (Blob)request.execute();
        if (tmpFile != null) {
            tmpFile.delete();
        }
        documentService.setProperty((DocRef)this.document, "dc:title", this.document.getTitle());
        return blob;
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isBlank((String)this.parentId)) {
            builder.append("Document.AddComment: ");
        } else {
            builder.append("Document.CreateChildComment: ");
        }
        builder.append(this.document.getTitle());
        return builder.toString();
    }
}

