/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.list.DocumentQueryCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import javax.portlet.PortletContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSHandlerProperties;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ListTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSCustomizer
extends DefaultCMSCustomizer {
    private static final String STYLE_NEWS = "actualite";
    private static final String STYLE_BLOG = "blog";
    private static final String STYLE_SLIDER = "slider";
    private static final String STYLE_FORUM = "forum";
    private static final String STYLE_TILE = "tuile";
    private static final String STYLE_ROADMAP = "roadmap";
    private static final String STYLE_DISTRIB = "distrib";
    private static final String SCHEMAS_ANNONCE = "dublincore,common, toutatice, note, annonce";
    private static final String SCHEMAS_SEARCH = "dublincore,common, toutatice, wcm_navigation, wcm_content";
    private static final String SCHEMAS_BLOG = "dublincore, common, toutatice, webpage";
    private static final String SCHEMAS_FORUM = "dublincore, common, toutatice";
    private static final String SCHEMAS_ZOOM = "dublincore, common, toutatice, zoom";
    private static final String SCHEMAS_DISTRIB = "dublincore, toutatice, roadmapdistrib";
    public static final String IDENT_PERMALINK_URL = "/purl/";

    public CMSCustomizer(PortletContext ctx) {
        super(ctx);
    }

    public List<ListTemplate> getListTemplates(Locale locale) {
        List templates = super.getListTemplates(locale);
        Bundle bundle = this.getBundleFactory().getBundle(locale);
        templates.add(new ListTemplate(STYLE_NEWS, bundle.getString("LIST_TEMPLATE_NEWS"), SCHEMAS_ANNONCE));
        templates.add(new ListTemplate(STYLE_BLOG, bundle.getString("LIST_TEMPLATE_BLOG"), SCHEMAS_BLOG));
        templates.add(new ListTemplate(STYLE_FORUM, bundle.getString("LIST_TEMPLATE_FORUM"), SCHEMAS_FORUM));
        templates.add(new ListTemplate(STYLE_SLIDER, bundle.getString("LIST_TEMPLATE_SLIDER"), SCHEMAS_ANNONCE));
        templates.add(new ListTemplate(STYLE_TILE, bundle.getString("LIST_TEMPLATE_TILES"), SCHEMAS_ZOOM));
        templates.add(new ListTemplate(STYLE_ROADMAP, bundle.getString("LIST_TEMPLATE_ROADMAP"), SCHEMAS_DISTRIB));
        templates.add(new ListTemplate(STYLE_DISTRIB, bundle.getString("LIST_TEMPLATE_ROADMAP_DISTRIBUTION"), SCHEMAS_DISTRIB));
        return templates;
    }

    public static String getSearchSchema() {
        return SCHEMAS_SEARCH;
    }

    public SortedMap<String, String> getMenuTemplates(Locale locale) {
        SortedMap templates = super.getMenuTemplates(locale);
        Bundle bundle = this.getBundleFactory().getBundle(locale);
        templates.put("commercial", bundle.getString("MENU_TEMPLATE_COMMERCIAL"));
        return templates;
    }

    public String getNuxeoNativeViewerUrl(CMSServiceCtx ctx) {
        String url = null;
        Document doc = (Document)ctx.getDoc();
        if ("PictureBook".equals(doc.getType())) {
            this.getNuxeoConnectionProps();
            url = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + doc.getId() + "/view_documents?tabId=tab_slideshow";
        }
        return url;
    }

    public CMSHandlerProperties getCMSDefaultPlayer(CMSServiceCtx ctx) throws Exception {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", "0");
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewDocumentPortletInstance");
        return linkProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws Exception {
        HashMap<String, String> cmsCommandProperties = new HashMap();
        if (requestPath.startsWith(IDENT_PERMALINK_URL)) {
            String[] ident = requestPath.split("/");
            String clause = " (ecm:primaryType = 'WikiBook' or ecm:primaryType = 'WikiSection') and webc:url = '" + ident[2] + "'";
            String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_DEFAULT, (String)clause);
            String savedScope = cmsCtx.getScope();
            cmsCtx.setScope("superuser_context");
            try {
                Documents documents = (Documents)this.getCmsService().executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentQueryCommand(filteredClause));
                if (documents.size() != 1) {
                    throw new CMSException(3);
                }
                cmsCommandProperties.put("cmsPath", documents.get(0).getPath());
            }
            finally {
                cmsCtx.setScope(savedScope);
            }
        } else {
            cmsCommandProperties = super.parseCMSURL(cmsCtx, requestPath, requestParameters);
        }
        return cmsCommandProperties;
    }

    public CMSHandlerProperties getCMSPlayer(CMSServiceCtx ctx) throws Exception {
        List tags;
        Document doc = (Document)ctx.getDoc();
        if ("WikiBook".equals(doc.getType()) || "WikiSection".equals(doc.getType())) {
            return this.getWikiPlayer(ctx);
        }
        if ("FaqFolder".equals(doc.getType()) || "Question".equals(doc.getType())) {
            return this.getFaqPlayer(ctx);
        }
        if ("BlogPost".equals(doc.getType())) {
            return this.getCMSMinimalPlayer(ctx);
        }
        if ("Forum".equals(doc.getType())) {
            return this.getForumPlayer(ctx);
        }
        if ("Thread".equals(doc.getType())) {
            return this.getForumThreadPlayer(ctx);
        }
        if ("Product".equals(doc.getType())) {
            return this.getRoadmapPlayer(ctx);
        }
        if ("Distribution".equals(doc.getType())) {
            return this.getDistributionPlayer(ctx);
        }
        if ("Agenda".equals(doc.getType())) {
            return this.getCalendarPlayer(ctx);
        }
        if ("VEVENT".equals(doc.getType())) {
            return this.getEventPlayer(ctx);
        }
        PropertyList subjMetatdata = doc.getProperties().getList("dc:subjects");
        if (subjMetatdata != null && !subjMetatdata.isEmpty() && (tags = subjMetatdata.list()).contains(STYLE_NEWS)) {
            return this.getCMSDefaultPlayer(ctx);
        }
        return super.getCMSPlayer(ctx);
    }

    private CMSHandlerProperties getWikiPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("osivia-services-wiki-wikiPortletInstance");
        return linkProps;
    }

    private CMSHandlerProperties getFaqPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-faq-portletInstance");
        return linkProps;
    }

    private CMSHandlerProperties getForumPlayer(CMSServiceCtx ctx) throws CMSException {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createForumPlayerRequest(ctx));
        windowProperties.put("osivia.cms.style", STYLE_FORUM);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    private String createForumPlayerRequest(CMSServiceCtx cmsContext) throws CMSException {
        Document document = (Document)cmsContext.getDoc();
        CMSPublicationInfos pubInfos = this.getCmsService().getPublicationInfos(cmsContext, document.getPath());
        StringBuilder request = new StringBuilder();
        request.append("ecm:parentId = '").append(pubInfos.getLiveId()).append("' ");
        request.append("AND ecm:primaryType = 'Thread' ");
        request.append("ORDER BY dc:modified DESC ");
        return request.toString();
    }

    private CMSHandlerProperties getForumThreadPlayer(CMSServiceCtx cmsContext) {
        Document document = (Document)cmsContext.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", document.getPath());
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("osivia-services-forum-portletInstance");
        return linkProps;
    }

    private CMSHandlerProperties getCalendarPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.title", doc.getTitle());
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("osivia.ajaxLink", "0");
        windowProperties.put("osivia.cms.hideMetaDatas", "1");
        windowProperties.put("osivia.calendar.cmsPath", "${contentPath}");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("osivia-services-calendar-instance");
        return linkProps;
    }

    private CMSHandlerProperties getEventPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.title", doc.getTitle());
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("osivia.ajaxLink", "0");
        windowProperties.put("osivia.cms.hideMetaDatas", "1");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("osivia-services-calendar-event-instance");
        return linkProps;
    }

    private CMSHandlerProperties getCMSMinimalPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.cms.hideMetaDatas", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewDocumentPortletInstance");
        return linkProps;
    }

    private CMSHandlerProperties getRoadmapPlayer(CMSServiceCtx ctx) throws CMSException {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createRoadmapPlayerRequest(ctx));
        windowProperties.put("osivia.title", "Roadmap");
        windowProperties.put("osivia.cms.style", STYLE_ROADMAP);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    private String createRoadmapPlayerRequest(CMSServiceCtx cmsContext) throws CMSException {
        Document document = (Document)cmsContext.getDoc();
        CMSPublicationInfos pubInfos = this.getCmsService().getPublicationInfos(cmsContext, document.getPath());
        StringBuilder request = new StringBuilder();
        request.append("ecm:parentId = '").append(pubInfos.getLiveId()).append("' ");
        request.append("ORDER BY rmpd:releaseDate DESC ");
        return request.toString();
    }

    private CMSHandlerProperties getDistributionPlayer(CMSServiceCtx ctx) throws CMSException {
        Document document = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createDistributionPlayerRequest(ctx));
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("osivia.title", document.getTitle());
        windowProperties.put("osivia.cms.style", STYLE_DISTRIB);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    private String createDistributionPlayerRequest(CMSServiceCtx cmsContext) throws CMSException {
        Document document = (Document)cmsContext.getDoc();
        StringBuilder request = new StringBuilder();
        request.append("ecm:uuid = '").append(document.getId()).append("' ");
        request.append("ORDER BY rmpd:releaseDate DESC ");
        return request.toString();
    }

    public Map<String, CMSItemType> getCMSItemTypes() {
        Map cmsItemTypes = super.getCMSItemTypes();
        List customizedTypes = this.getCustomizedCMSItemTypes();
        for (CMSItemType customizedType : customizedTypes) {
            cmsItemTypes.put(customizedType.getName(), customizedType);
        }
        return cmsItemTypes;
    }

    private List<CMSItemType> getCustomizedCMSItemTypes() {
        ArrayList<CMSItemType> customizedTypes = new ArrayList<CMSItemType>();
        customizedTypes.add(new CMSItemType("FaqFolder", true, false, false, false, true, Arrays.asList("Question"), null));
        customizedTypes.add(new CMSItemType("Question", false, false, false, false, true, new ArrayList(0), null));
        customizedTypes.add(new CMSItemType("BlogSite", true, false, false, true, true, Arrays.asList("BlogPost"), "/default/templates/blogSite"));
        customizedTypes.add(new CMSItemType("BlogPost", false, false, false, true, true, new ArrayList(0), null));
        customizedTypes.add(new CMSItemType("WikiBook", true, true, true, true, true, Arrays.asList("WikiSection"), null));
        customizedTypes.add(new CMSItemType("WikiSection", true, true, true, true, true, Arrays.asList("WikiSection"), null));
        customizedTypes.add(new CMSItemType("Forum", true, true, false, true, true, Arrays.asList("Thread"), null));
        customizedTypes.add(new CMSItemType("Thread", false, false, false, true, true, new ArrayList(0), null));
        customizedTypes.add(new CMSItemType("Product", true, true, true, true, true, Arrays.asList("Distribution"), null));
        customizedTypes.add(new CMSItemType("Distribution", false, true, true, true, true, new ArrayList(0), null));
        customizedTypes.add(new CMSItemType("Agenda", false, true, false, false, true, Arrays.asList("VEVENT"), null));
        customizedTypes.add(new CMSItemType("VEVENT", false, false, false, false, true, new ArrayList(0), null));
        return customizedTypes;
    }
}

