/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.LinkFragment;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.core.web.IWebIdService;

public class LinksFragmentModule
implements IFragmentModule {
    public static final String ID = "links_property";
    public static final String DESC = "Liste de liens";
    public static final String JSP = "links";
    public static final String ADMIN_JSP = "links";
    private static final String REF_URI = "refURI";
    private static final String TEMPLATE = "linksTemplate";
    private final IWebIdService webIdService = (IWebIdService)Locator.findMBean(IWebIdService.class, (String)"osivia:service=webIdService");

    public void injectViewAttributes(NuxeoController nuxeoController, PortalWindow window, PortletRequest request, RenderResponse response) throws Exception {
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        boolean emptyContent = true;
        if (StringUtils.isNotEmpty((String)nuxeoPath)) {
            String refURI;
            Document document = nuxeoController.fetchDocument(nuxeoPath = nuxeoController.getComputedPath(nuxeoPath));
            if (document.getTitle() != null) {
                response.setTitle(document.getTitle());
            }
            if (StringUtils.isNotEmpty((String)(refURI = window.getProperty("osivia.refURI")))) {
                String linksFragmentsSchema;
                String refURIValue;
                PropertyMap propertyMap;
                int index;
                PropertyList dataContents;
                Object content;
                String linksSchema = "lk:links";
                if (StringUtils.isNotEmpty((String)linksSchema)) {
                    ArrayList<LinkFragment> links = new ArrayList<LinkFragment>();
                    content = document.getProperties().get(linksSchema);
                    if (content instanceof PropertyList && (dataContents = (PropertyList)content) != null && dataContents.size() > 0) {
                        for (index = 0; index < dataContents.size(); ++index) {
                            LinkFragment link;
                            propertyMap = dataContents.getMap(index);
                            refURIValue = (String)propertyMap.get(REF_URI);
                            String href = propertyMap.getString("href");
                            if (!refURI.equalsIgnoreCase(refURIValue) || !StringUtils.isNotBlank((String)href)) continue;
                            if (StringUtils.startsWith((String)href, (String)"/")) {
                                link = new LinkFragment(nuxeoController.getCMSLinkByPath(href, null));
                            } else if (StringUtils.startsWith((String)href, (String)"http")) {
                                String urlServerName;
                                String serverName = nuxeoController.getRequest().getServerName();
                                boolean external = !StringUtils.equals((String)serverName, (String)(urlServerName = StringUtils.substringBefore((String)StringUtils.substringAfter((String)href, (String)"://"), (String)"/")));
                                link = new LinkFragment(href, external);
                            } else if (StringUtils.isBlank((String)href)) {
                                link = new LinkFragment("#", false);
                            } else {
                                String path = this.webIdService.webPathToPageUrl(href);
                                link = new LinkFragment(nuxeoController.getCMSLinkByPath(path, null));
                            }
                            link.setTitle(propertyMap.getString("title"));
                            link.setGlyphicon(propertyMap.getString("icon"));
                            links.add(link);
                        }
                    }
                    if (!links.isEmpty()) {
                        request.setAttribute("links", links);
                        emptyContent = false;
                    }
                }
                if (StringUtils.isNotEmpty((String)(linksFragmentsSchema = "lkfgt:linksFragment")) && (content = document.getProperties().get(linksFragmentsSchema)) instanceof PropertyList && (dataContents = (PropertyList)content) != null && dataContents.size() > 0) {
                    for (index = 0; index < dataContents.size(); ++index) {
                        propertyMap = dataContents.getMap(index);
                        refURIValue = (String)propertyMap.get(REF_URI);
                        if (!refURI.equalsIgnoreCase(refURIValue)) continue;
                        request.setAttribute("template", (Object)propertyMap.getString(TEMPLATE));
                        break;
                    }
                }
            }
        }
        if (emptyContent) {
            request.setAttribute("osivia.emptyResponse", (Object)"1");
        }
    }

    public void injectAdminAttributes(NuxeoController ctx, PortalWindow window, PortletRequest request, RenderResponse response) throws Exception {
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        request.setAttribute("nuxeoPath", (Object)StringUtils.trimToEmpty((String)nuxeoPath));
        request.setAttribute("propertyName", (Object)"lk:links");
        String scope = window.getProperty("osivia.cms.forcePublicationScope");
        request.setAttribute("scope", (Object)scope);
    }

    public void processAdminAttributes(NuxeoController ctx, PortalWindow window, ActionRequest request, ActionResponse res) throws Exception {
        if (request.getParameter("nuxeoPath") != null) {
            window.setProperty("osivia.cms.uri", request.getParameter("nuxeoPath"));
        }
        if (request.getParameter("scope") != null && request.getParameter("scope").length() > 0) {
            window.setProperty("osivia.cms.forcePublicationScope", request.getParameter("scope"));
        } else if (window.getProperty("osivia.cms.forcePublicationScope") != null) {
            window.setProperty("osivia.cms.forcePublicationScope", null);
        }
    }
}

