/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.files.SubType;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.api.html.AccessibilityRoles;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.EcmCommand;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;

public class MenuBarFormater {
    private final CMSService cmsService;
    private final IPortalUrlFactory urlFactory;
    private final DefaultCMSCustomizer customizer;
    private final IContributionService contributionService;
    private final IBundleFactory bundleFactory;

    public MenuBarFormater(PortletContext portletCtx, DefaultCMSCustomizer customizer, CMSService cmsService) {
        this.cmsService = cmsService;
        this.urlFactory = (IPortalUrlFactory)portletCtx.getAttribute("UrlService");
        this.customizer = customizer;
        this.contributionService = (IContributionService)Locator.findMBean(IContributionService.class, (String)"osivia:service=ContributionService");
        IInternationalizationService internationalizationService = (IInternationalizationService)portletCtx.getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void formatDefaultContentMenuBar(CMSServiceCtx cmsCtx) throws Exception {
        block14: {
            if (cmsCtx.getDoc() == null && cmsCtx.getCreationPath() == null) {
                return;
            }
            PortletRequest request = cmsCtx.getRequest();
            List menubar = (List)request.getAttribute("osivia.menuBar");
            boolean webPageFragment = false;
            if (cmsCtx.getDoc() != null) {
                String webPagePath = (String)request.getAttribute("osivia.cms.webPagePath");
                String docLivePath = ContextualizationHelper.getLivePath((String)((Document)cmsCtx.getDoc()).getPath());
                if (StringUtils.equals((String)docLivePath, (String)webPagePath)) {
                    webPageFragment = true;
                }
            }
            try {
                if (cmsCtx.getDoc() != null && !webPageFragment) {
                    this.getPermaLinkLink(cmsCtx, menubar);
                }
                if (cmsCtx.getDoc() != null && !webPageFragment) {
                    this.getContextualizationLink(cmsCtx, menubar);
                }
                if (cmsCtx.getDoc() != null && !webPageFragment) {
                    this.getChangeModeLink(cmsCtx, menubar);
                }
                this.getLiveContentBrowserLink(cmsCtx, menubar);
                if (cmsCtx.getDoc() != null && !webPageFragment) {
                    this.getEditLink(cmsCtx, menubar);
                }
                this.getCreateLink(cmsCtx, menubar);
                if (cmsCtx.getDoc() != null && !webPageFragment) {
                    this.getDeleteLink(cmsCtx, menubar);
                }
                if (cmsCtx.getDoc() != null && !webPageFragment) {
                    this.getAdministrationLink(cmsCtx, menubar);
                }
                if (cmsCtx.getDoc() != null && !webPageFragment) {
                    this.getBackLink(cmsCtx, menubar);
                }
                if (cmsCtx.getDoc() != null && !webPageFragment) {
                    this.getDriveEditUrl(cmsCtx, menubar);
                }
                if (cmsCtx.getDoc() != null && !webPageFragment) {
                    this.getSynchronizeLink(cmsCtx, menubar);
                }
            }
            catch (CMSException e) {
                if (e.getErrorCode() == 1 || e.getErrorCode() == 3) break block14;
                throw e;
            }
        }
    }

    protected void adaptDropdowMenu(CMSServiceCtx cmsCtx) throws Exception {
        PortletRequest request = cmsCtx.getRequest();
        List menubar = (List)request.getAttribute("osivia.menuBar");
        MenubarItem duplicateItem = null;
        boolean otherItem = false;
        int indice = -1;
        int addIndice = -1;
        for (MenubarItem menuItem : menubar) {
            ++indice;
            if (!menuItem.isDropdownItem()) continue;
            if ("ADD".equals(menuItem.getId())) {
                duplicateItem = menuItem.clone();
                duplicateItem.setDropdownItem(false);
                addIndice = indice;
                continue;
            }
            otherItem = true;
        }
        if (duplicateItem != null) {
            menubar.add(duplicateItem);
            if (!otherItem) {
                menubar.remove(addIndice);
            }
        }
    }

    public void formatContentMenuBar(CMSServiceCtx cmsCtx) throws Exception {
        this.formatDefaultContentMenuBar(cmsCtx);
        this.adaptDropdowMenu(cmsCtx);
    }

    protected boolean isInLiveMode(CMSServiceCtx cmsCtx, CMSPublicationInfos pubInfos) {
        boolean liveMode = false;
        IContributionService.EditionState curState = (IContributionService.EditionState)cmsCtx.getRequest().getAttribute("osivia.editionState");
        if (curState != null && curState.getContributionMode().equals(IContributionService.EditionState.CONTRIBUTION_MODE_EDITION) && curState.getDocPath().equals(pubInfos.getDocumentPath())) {
            liveMode = true;
        }
        return liveMode;
    }

    protected boolean isRemoteProxy(CMSServiceCtx cmsCtx, CMSPublicationInfos pubInfos) {
        if (cmsCtx.getDoc() == null) {
            return false;
        }
        if (pubInfos.isPublished() && !this.isInLiveMode(cmsCtx, pubInfos)) {
            String docPath = ((Document)cmsCtx.getDoc()).getPath();
            if (pubInfos.getDocumentPath().equals(docPath)) {
                return true;
            }
        }
        return false;
    }

    protected void getAdministrationLink(CMSServiceCtx cmsCtx, List<MenubarItem> menuBar) throws Exception {
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, ((Document)cmsCtx.getDoc()).getPath());
        if (this.isRemoteProxy(cmsCtx, pubInfos)) {
            return;
        }
        if (pubInfos.isEditableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            Bundle bundle = this.bundleFactory.getBundle(cmsCtx.getRequest().getLocale());
            String url = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + pubInfos.getLiveId() + "/view_documents";
            MenubarItem item = new MenubarItem("MANAGE", bundle.getString("MANAGE"), 43, url, null, null, "nuxeo");
            item.setGlyphicon("halflings new_window");
            item.setAjaxDisabled(true);
            item.setDropdownItem(true);
            menuBar.add(item);
        }
    }

    protected void getChangeModeLink(CMSServiceCtx cmsCtx, List<MenubarItem> menubar) throws Exception {
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsCtx.getDoc();
        String path = document.getPath();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, path);
        if (pubInfos.isEditableByUser() && !pubInfos.isLiveSpace() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            IContributionService.EditionState editionState;
            Bundle bundle = this.bundleFactory.getBundle(cmsCtx.getRequest().getLocale());
            PortalControllerContext portalControllerContext = new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse());
            if (this.isInLiveMode(cmsCtx, pubInfos)) {
                editionState = new IContributionService.EditionState(IContributionService.EditionState.CONTRIBUTION_MODE_ONLINE, path);
                MenubarItem liveIndicator = new MenubarItem("LIVE_VERSION", bundle.getString("LIVE_VERSION"), 40, null, null, null, null);
                liveIndicator.setGlyphicon("notes_2");
                liveIndicator.setStateItem(true);
                menubar.add(liveIndicator);
                if (pubInfos.isOnLinePending()) {
                    MenubarItem pendingIndicator = new MenubarItem("ON_LINE_WF_PENDING", bundle.getString("ON_LINE_WF_PENDING"), 40, null, null, null, null);
                    pendingIndicator.setGlyphicon("history");
                    pendingIndicator.setStateItem(true);
                    menubar.add(pendingIndicator);
                }
            } else {
                editionState = new IContributionService.EditionState(IContributionService.EditionState.CONTRIBUTION_MODE_EDITION, path);
            }
            if (!this.isRemoteProxy(cmsCtx, pubInfos)) {
                if (this.isInLiveMode(cmsCtx, pubInfos)) {
                    if (pubInfos.isUserCanValidate()) {
                        if (pubInfos.isOnLinePending()) {
                            this.addValidatePublishingItems(portalControllerContext, cmsCtx, menubar, pubInfos);
                        } else if (pubInfos.isBeingModified()) {
                            String publishURL = this.contributionService.getPublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                            MenubarItem publishItem = new MenubarItem("PUBLISH", bundle.getString("PUBLISH"), 52, publishURL, null, null, null);
                            publishItem.setGlyphicon("halflings ok-circle");
                            publishItem.setAjaxDisabled(true);
                            publishItem.setDropdownItem(true);
                            menubar.add(publishItem);
                        }
                    } else {
                        if (!pubInfos.isOnLinePending() && pubInfos.isBeingModified()) {
                            String askPublishURL = this.getContributionService().getAskPublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                            MenubarItem askPublishItem = new MenubarItem("ASK_PUBLISH", bundle.getString("ASK_PUBLISH"), 52, askPublishURL, null, null, null);
                            askPublishItem.setGlyphicon("chat");
                            askPublishItem.setAjaxDisabled(true);
                            askPublishItem.setDropdownItem(true);
                            menubar.add(askPublishItem);
                        }
                        if (pubInfos.isOnLinePending() && pubInfos.isUserOnLineInitiator()) {
                            String cancelAskPublishURL = this.getContributionService().getCancelPublishingAskContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                            MenubarItem cancelAskPublishItem = new MenubarItem("CANCEL_ASK_PUBLISH", bundle.getString("CANCEL_ASK_PUBLISH"), 52, cancelAskPublishURL, null, null, null);
                            cancelAskPublishItem.setGlyphicon("halflings remove-circle");
                            cancelAskPublishItem.setAjaxDisabled(true);
                            cancelAskPublishItem.setDropdownItem(true);
                            menubar.add(cancelAskPublishItem);
                        }
                    }
                    if (pubInfos.isPublished()) {
                        String proxyURL = this.getContributionService().getChangeEditionStateUrl(portalControllerContext, editionState);
                        MenubarItem proxyItem = new MenubarItem("PROXY_RETURN", bundle.getString("PROXY_RETURN"), 40, proxyURL, null, null, null);
                        proxyItem.setGlyphicon("halflings eye-close");
                        proxyItem.setAjaxDisabled(true);
                        proxyItem.setDropdownItem(true);
                        menubar.add(proxyItem);
                    }
                } else {
                    if (pubInfos.isUserCanValidate()) {
                        String unpublishURL = this.contributionService.getUnpublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                        MenubarItem unpublishItem = new MenubarItem("UNPUBLISH", bundle.getString("UNPUBLISH"), 52, unpublishURL, null, null, null);
                        unpublishItem.setGlyphicon("halflings remove-circle");
                        unpublishItem.setAjaxDisabled(true);
                        unpublishItem.setDropdownItem(true);
                        menubar.add(unpublishItem);
                    }
                    if (pubInfos.isBeingModified()) {
                        MenubarItem modificationIndicator = new MenubarItem("MODIFICATION_MESSAGE", bundle.getString("MODIFICATION_MESSAGE"), 40, null, null, null, null);
                        modificationIndicator.setGlyphicon("halflings warning-sign");
                        modificationIndicator.setStateItem(true);
                        modificationIndicator.setDropdownItem(true);
                        menubar.add(modificationIndicator);
                        String previewURL = this.contributionService.getChangeEditionStateUrl(portalControllerContext, editionState);
                        MenubarItem previewItem = new MenubarItem("LIVE_PREVIEW", bundle.getString("LIVE_PREVIEW"), 41, previewURL, null, null, null);
                        previewItem.setGlyphicon("halflings eye-open");
                        previewItem.setAjaxDisabled(true);
                        previewItem.setDropdownItem(true);
                        menubar.add(previewItem);
                    }
                }
            }
        }
    }

    protected void addValidatePublishingItems(PortalControllerContext portalControllerContext, CMSServiceCtx cmsCtx, List<MenubarItem> menubar, CMSPublicationInfos pubInfos) throws Exception {
        Bundle bundle = this.bundleFactory.getBundle(cmsCtx.getRequest().getLocale());
        String validateUrl = this.getContributionService().getValidatePublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
        MenubarItem validateItem = new MenubarItem("ONLINE_WF_VALIDATE", bundle.getString("VALIDATE_PUBLISH"), 52, validateUrl, null, null, null);
        validateItem.setGlyphicon("halflings ok-circle");
        validateItem.setAjaxDisabled(true);
        validateItem.setDropdownItem(true);
        menubar.add(validateItem);
        String rejectUrl = this.getContributionService().getRejectPublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
        MenubarItem rejectItem = new MenubarItem("ONLINE_WF_REJECT", bundle.getString("REJECT_PUBLISH"), 53, rejectUrl, null, null, null);
        rejectItem.setGlyphicon("halflings remove-circle");
        rejectItem.setAjaxDisabled(true);
        rejectItem.setDropdownItem(true);
        menubar.add(rejectItem);
    }

    protected void getLiveContentBrowserLink(CMSServiceCtx cmsCtx, List<MenubarItem> menubar) throws Exception {
        boolean folderish;
        String path;
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        if (!ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            return;
        }
        PortalControllerContext portalControllerContext = new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse());
        Document document = (Document)cmsCtx.getDoc();
        if (document == null) {
            path = cmsCtx.getCreationPath();
            folderish = path != null;
        } else {
            path = document.getPath();
            CMSItemType cmsItemType = (CMSItemType)this.customizer.getCMSItemTypes().get(document.getType());
            folderish = cmsItemType != null && cmsItemType.isFolderish();
        }
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, path);
        if (this.isRemoteProxy(cmsCtx, pubInfos)) {
            return;
        }
        if (!pubInfos.isLiveSpace() && !pubInfos.getSubTypes().isEmpty() && folderish) {
            Bundle bundle = this.bundleFactory.getBundle(cmsCtx.getRequest().getLocale());
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("osivia.browser.path", path);
            HashMap parameters = new HashMap(0);
            String browserUrl = this.urlFactory.getStartPortletUrl(portalControllerContext, "osivia-portal-browser-portlet-instance", properties, parameters, true);
            MenubarItem browserItem = new MenubarItem("BROWSE_LIVE_CONTENT", bundle.getString("BROWSE_LIVE_CONTENT"), 44, browserUrl, null, "fancyframe_refresh", null);
            browserItem.setGlyphicon("halflings search");
            browserItem.setAjaxDisabled(true);
            browserItem.setDropdownItem(true);
            menubar.add(browserItem);
        }
    }

    protected void getDriveEditUrl(CMSServiceCtx cmsCtx, List<MenubarItem> menubar) throws CMSException {
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        if (!ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            return;
        }
        Document document = (Document)cmsCtx.getDoc();
        String path = document.getPath();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, path);
        if (pubInfos.getDriveEditURL() != null) {
            Bundle bundle = this.bundleFactory.getBundle(cmsCtx.getRequest().getLocale());
            MenubarItem driveEditItem = new MenubarItem("DRIVE_EDIT", bundle.getString("DRIVE_EDIT"), 104, pubInfos.getDriveEditURL(), null, null, null);
            driveEditItem.setGlyphicon("halflings play");
            driveEditItem.setAjaxDisabled(true);
            driveEditItem.setDropdownItem(true);
            menubar.add(driveEditItem);
        }
    }

    protected void getSynchronizeLink(CMSServiceCtx cmsCtx, List<MenubarItem> menubar) throws CMSException {
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        if (!ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            return;
        }
        Bundle bundle = this.bundleFactory.getBundle(cmsCtx.getRequest().getLocale());
        Document document = (Document)cmsCtx.getDoc();
        String path = document.getPath();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, path);
        Boolean enableParamter = null;
        String command = null;
        String icon = null;
        if (pubInfos.isCanSynchronize()) {
            enableParamter = true;
            command = "SYNCHRONIZE";
            icon = "refresh";
        } else if (pubInfos.isCanUnsynchronize()) {
            enableParamter = false;
            command = "UNSYNCHRONIZE";
            icon = "ban-circle";
        }
        if (enableParamter != null) {
            String synchronizeUrl = this.urlFactory.getSynchronizationCommandUrl(new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse()), pubInfos.getDocumentPath(), enableParamter);
            MenubarItem synchronizeItem = new MenubarItem(command, bundle.getString(command), 105, synchronizeUrl, null, null, null);
            synchronizeItem.setGlyphicon("halflings " + icon);
            synchronizeItem.setAjaxDisabled(true);
            synchronizeItem.setDropdownItem(true);
            menubar.add(synchronizeItem);
        } else if (pubInfos.getSynchronizationRootPath() != null) {
            String rootUrl = this.urlFactory.getCMSUrl(new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse()), null, pubInfos.getSynchronizationRootPath(), null, null, null, null, null, null, null);
            MenubarItem rootUrlItem = new MenubarItem("SYNCHRO_ROOT_URL", bundle.getString("SYNCHRO_ROOT_URL"), 105, rootUrl, null, null, null);
            rootUrlItem.setGlyphicon("halflings backward");
            rootUrlItem.setAjaxDisabled(true);
            rootUrlItem.setDropdownItem(true);
            menubar.add(rootUrlItem);
        }
    }

    protected void getEditLink(CMSServiceCtx cmsCtx, List<MenubarItem> menubar) throws Exception {
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, ((Document)cmsCtx.getDoc()).getPath());
        if (this.isRemoteProxy(cmsCtx, pubInfos)) {
            return;
        }
        if (pubInfos.isEditableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            Document doc = (Document)cmsCtx.getDoc();
            CMSItemType cmsItemType = (CMSItemType)this.customizer.getCMSItemTypes().get(doc.getType());
            if (cmsItemType != null && cmsItemType.isSupportsPortalForms()) {
                Bundle bundle = this.bundleFactory.getBundle(cmsCtx.getRequest().getLocale());
                PortalControllerContext portalControllerContext = new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse());
                String callbackURL = this.urlFactory.getCMSUrl(portalControllerContext, null, "_NEWID_", null, null, "_LIVE_", null, null, null, null);
                String ecmBaseURL = this.cmsService.getEcmDomain(cmsCtx);
                HashMap requestParameters = new HashMap();
                String url = this.cmsService.getEcmUrl(cmsCtx, EcmCommand.editDocument, pubInfos.getDocumentPath(), requestParameters);
                StringBuilder onClick = new StringBuilder();
                onClick.append("javascript:setCallbackFromEcmParams('");
                onClick.append(callbackURL);
                onClick.append("', '");
                onClick.append(ecmBaseURL);
                onClick.append("');");
                String editLabel = null;
                editLabel = !pubInfos.isLiveSpace() && !this.isInLiveMode(cmsCtx, pubInfos) && pubInfos.isBeingModified() ? bundle.getString("EDIT_LIVE_VERSION") : bundle.getString("EDIT");
                MenubarItem item = new MenubarItem("EDIT", editLabel, 42, url, onClick.toString(), "fancyframe_refresh", null);
                item.setGlyphicon("halflings edit");
                item.setAjaxDisabled(true);
                item.setDropdownItem(true);
                menubar.add(item);
            }
        }
    }

    protected void getCreateLink(CMSServiceCtx cmsCtx, List<MenubarItem> menubar) throws Exception {
        CMSPublicationInfos pubInfos;
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        String creationType = cmsCtx.getCreationType();
        String creationPath = cmsCtx.getCreationPath();
        Document parentDoc = (Document)cmsCtx.getDoc();
        if (creationPath != null) {
            parentDoc = (Document)this.cmsService.getContent(cmsCtx, creationPath).getNativeItem();
        }
        if (this.isRemoteProxy(cmsCtx, pubInfos = this.cmsService.getPublicationInfos(cmsCtx, parentDoc.getPath()))) {
            return;
        }
        if (creationPath != null || ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            Bundle bundle = this.bundleFactory.getBundle(cmsCtx.getRequest().getLocale());
            PortalControllerContext portalControllerContext = new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse());
            String callbackURL = this.urlFactory.getRefreshPageUrl(portalControllerContext);
            String ecmBaseURL = this.cmsService.getEcmDomain(cmsCtx);
            StringBuilder onClick = new StringBuilder();
            onClick.append("javascript:setCallbackFromEcmParams('");
            onClick.append(callbackURL);
            onClick.append("', '");
            onClick.append(ecmBaseURL);
            onClick.append("');");
            Map subTypes = pubInfos.getSubTypes();
            ArrayList<SubType> portalDocsToCreate = new ArrayList<SubType>();
            Map managedTypes = this.customizer.getCMSItemTypes();
            CMSItemType containerDocType = (CMSItemType)managedTypes.get(parentDoc.getType());
            if (containerDocType != null) {
                for (String docType : subTypes.keySet()) {
                    CMSItemType docTypeDef;
                    if (!containerDocType.getPortalFormSubTypes().contains(docType) || creationType != null && !creationType.equals(docType) || (docTypeDef = (CMSItemType)managedTypes.get(docType)) == null || !docTypeDef.isSupportsPortalForms()) continue;
                    HashMap<String, String> requestParameters = new HashMap<String, String>();
                    requestParameters.put("type", docType);
                    String url = this.cmsService.getEcmUrl(cmsCtx, EcmCommand.createDocument, pubInfos.getDocumentPath(), requestParameters);
                    SubType subType = new SubType();
                    subType.setDocType(docType);
                    subType.setName(bundle.getString(docType.toUpperCase()));
                    subType.setUrl(url);
                    portalDocsToCreate.add(subType);
                }
            }
            if (portalDocsToCreate.size() == 1) {
                HashMap<String, String> requestParameters = new HashMap<String, String>();
                requestParameters.put("type", ((SubType)portalDocsToCreate.get(0)).getDocType());
                String url = this.cmsService.getEcmUrl(cmsCtx, EcmCommand.createDocument, pubInfos.getDocumentPath(), requestParameters);
                MenubarItem item = new MenubarItem("ADD", bundle.getString("ADD"), 46, url, onClick.toString(), "fancyframe_refresh portlet-menuitem-edition add", "nuxeo");
                item.setGlyphicon("halflings plus");
                item.setDropdownItem(true);
                item.setAjaxDisabled(true);
                menubar.add(item);
            } else if (portalDocsToCreate.size() > 0) {
                String contextPath = "/toutatice-portail-cms-nuxeo";
                String namespace = cmsCtx.getResponse().getNamespace();
                String fancyboxId = namespace + "_PORTAL_CREATE";
                Element container = DOM4JUtils.generateDivElement((String)"container-fluid");
                DOM4JUtils.addAttribute((Element)container, (String)"id", (String)fancyboxId);
                Element title = DOM4JUtils.generateElement((String)"p", (String)"lead", (String)bundle.getString("ADD_CONTENT"));
                container.add(title);
                Element row = DOM4JUtils.generateDivElement((String)"row");
                container.add(row);
                for (SubType subType : portalDocsToCreate) {
                    String documentType = subType.getDocType();
                    Element col = DOM4JUtils.generateDivElement((String)"col-xs-6");
                    row.add(col);
                    Element thumbnail = DOM4JUtils.generateLinkElement((String)subType.getUrl(), null, (String)onClick.toString(), (String)"thumbnail fancyframe_refresh", null);
                    col.add(thumbnail);
                    Element vignette = DOM4JUtils.generateElement((String)"img", null, null);
                    DOM4JUtils.addAttribute((Element)vignette, (String)"src", (String)(contextPath + "/img/icons/" + documentType.toLowerCase() + "_100.png"));
                    DOM4JUtils.addAttribute((Element)vignette, (String)"alt", (String)"");
                    thumbnail.add(vignette);
                    Element caption = DOM4JUtils.generateDivElement((String)"caption text-center");
                    caption.setText(bundle.getString(documentType.toUpperCase()));
                    thumbnail.add(caption);
                }
                String fancyCallbackURL = this.urlFactory.getRefreshPageUrl(portalControllerContext);
                String fancyOnClick = "setCallbackParams(null, '" + fancyCallbackURL + "')";
                MenubarItem item = new MenubarItem("ADD", bundle.getString("ADD"), 46, "#" + fancyboxId, fancyOnClick, "fancybox_inline", null);
                item.setGlyphicon("halflings plus");
                item.setAjaxDisabled(true);
                item.setAssociatedHtml(DOM4JUtils.write((Element)container));
                item.setDropdownItem(true);
                menubar.add(item);
            }
        }
    }

    protected void getDeleteLink(CMSServiceCtx cmsContext, List<MenubarItem> menubar) throws Exception {
        CMSItemType docTypeDef;
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsContext, document.getPath());
        if (this.isRemoteProxy(cmsContext, pubInfos)) {
            return;
        }
        if (pubInfos.isDeletableByUser() && (pubInfos.isLiveSpace() || this.isInLiveMode(cmsContext, pubInfos)) && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && (docTypeDef = (CMSItemType)this.customizer.getCMSItemTypes().get(document.getType())) != null && docTypeDef.isSupportsPortalForms()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("docId", document.getId());
            properties.put("docPath", document.getPath());
            Bundle bundle = this.bundleFactory.getBundle(cmsContext.getRequest().getLocale());
            String fancyboxId = cmsContext.getResponse().getNamespace() + "_PORTAL_DELETE";
            String putInTrashUrl = this.urlFactory.getPutDocumentInTrashUrl(new PortalControllerContext(cmsContext.getPortletCtx(), cmsContext.getRequest(), (PortletResponse)cmsContext.getResponse()), pubInfos.getLiveId(), pubInfos.getDocumentPath());
            String fancybox = this.generateDeleteConfirmationFancybox(properties, bundle, fancyboxId, putInTrashUrl);
            String url = "#" + fancyboxId;
            MenubarItem item = new MenubarItem("DELETE", bundle.getString("DELETE"), 60, url, null, "fancybox_inline", null);
            item.setGlyphicon("halflings remove");
            item.setAjaxDisabled(true);
            item.setAssociatedHtml(fancybox);
            item.setDropdownItem(true);
            menubar.add(item);
        }
    }

    private String generateDeleteConfirmationFancybox(Map<String, String> properties, Bundle bundle, String fancyboxId, String actionURL) {
        Element container = DOM4JUtils.generateDivElement((String)"container-fluid");
        DOM4JUtils.addAttribute((Element)container, (String)"id", (String)fancyboxId);
        Element form = DOM4JUtils.generateElement((String)"form", (String)"text-center", null, null, (AccessibilityRoles)AccessibilityRoles.FORM);
        DOM4JUtils.addAttribute((Element)form, (String)"action", (String)actionURL);
        DOM4JUtils.addAttribute((Element)form, (String)"method", (String)"post");
        container.add(form);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("CMS_DELETE_CONFIRM_MESSAGE"));
        form.add(message);
        for (Map.Entry<String, String> property : properties.entrySet()) {
            Element hidden = DOM4JUtils.generateElement((String)"input", null, null);
            DOM4JUtils.addAttribute((Element)hidden, (String)"type", (String)"hidden");
            DOM4JUtils.addAttribute((Element)hidden, (String)"name", (String)property.getKey());
            DOM4JUtils.addAttribute((Element)hidden, (String)"value", (String)property.getValue());
            form.add(hidden);
        }
        Element okButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default btn-warning", (String)bundle.getString("YES"), (String)"halflings warning-sign", null);
        DOM4JUtils.addAttribute((Element)okButton, (String)"type", (String)"submit");
        form.add(okButton);
        Element cancelButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("NO"));
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"type", (String)"button");
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"onclick", (String)"closeFancybox()");
        form.add(cancelButton);
        return DOM4JUtils.write((Element)container);
    }

    protected void addContextualizationLinkItem(List<MenubarItem> menuBar, String displayName, String url) throws Exception {
        MenubarItem item = new MenubarItem("CONTEXTUALIZE", "Espace " + displayName, 41, url, null, null, null);
        item.setGlyphicon("halflings share");
        item.setAjaxDisabled(true);
        menuBar.add(item);
    }

    protected void getContextualizationLink(CMSServiceCtx cmsCtx, List<MenubarItem> menuBar) throws Exception {
        Page page;
        if (!WindowState.MAXIMIZED.equals((Object)cmsCtx.getRequest().getWindowState())) {
            return;
        }
        PortalControllerContext portalCtx = new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse());
        Page currentPage = null;
        Window window = (Window)cmsCtx.getRequest().getAttribute("osivia.window");
        if (window != null) {
            currentPage = window.getPage();
        }
        if ((page = this.urlFactory.getPortalCMSContextualizedPage(portalCtx, ((Document)cmsCtx.getDoc()).getPath())) == null || !page.getId().equals((Object)currentPage.getId())) {
            String spaceDisplayName = null;
            if (page != null) {
                Locale locale = Locale.FRENCH;
                spaceDisplayName = page.getDisplayName().getString(locale, true);
                if (spaceDisplayName == null) {
                    spaceDisplayName = page.getName();
                }
            } else {
                CMSItem pubConfig;
                CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, ((Document)cmsCtx.getDoc()).getPath());
                if (pubInfos.getPublishSpacePath() != null && "1".equals((pubConfig = this.cmsService.getSpaceConfig(cmsCtx, pubInfos.getPublishSpacePath())).getProperties().get("contextualizeInternalContents"))) {
                    spaceDisplayName = pubInfos.getPublishSpaceDisplayName();
                }
            }
            if (spaceDisplayName != null) {
                String url = this.urlFactory.getCMSUrl(new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse()), currentPage.getId().toString(PortalObjectPath.CANONICAL_FORMAT), ((Document)cmsCtx.getDoc()).getPath(), null, "portal", null, null, null, null, null);
                this.addContextualizationLinkItem(menuBar, spaceDisplayName, url);
            }
        }
    }

    protected void addPermaLinkItem(CMSServiceCtx cmsContext, List<MenubarItem> menubar, String url) throws Exception {
        Bundle bundle = this.bundleFactory.getBundle(cmsContext.getRequest().getLocale());
        MenubarItem item = new MenubarItem("PERMALINK", bundle.getString("PERMALINK"), 40, url, null, null, null);
        item.setGlyphicon("halflings link");
        item.setAjaxDisabled(true);
        menubar.add(item);
    }

    protected void getPermaLinkLink(CMSServiceCtx cmsContext, List<MenubarItem> menubar) throws Exception {
        Portal portal;
        boolean spaceSite;
        if (!WindowState.MAXIMIZED.equals((Object)cmsContext.getRequest().getWindowState()) && !(spaceSite = PortalObjectUtils.isSpaceSite((PortalObject)(portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext()))))) {
            String permLinkPath = this.customizer.getContentWebIdPath(cmsContext);
            String permaLinkURL = this.urlFactory.getPermaLink(new PortalControllerContext(cmsContext.getPortletCtx(), cmsContext.getRequest(), (PortletResponse)cmsContext.getResponse()), null, null, permLinkPath, "cms");
            if (permaLinkURL != null) {
                this.addPermaLinkItem(cmsContext, menubar, permaLinkURL);
            }
        }
    }

    protected void getBackLink(CMSServiceCtx cmsCtx, List<MenubarItem> menubar) throws Exception {
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        if (!ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            return;
        }
        PortalControllerContext portalControllerContext = new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse());
        Document document = (Document)cmsCtx.getDoc();
        if (document == null) {
            return;
        }
        Bundle bundle = this.bundleFactory.getBundle(cmsCtx.getRequest().getLocale());
        IContributionService.EditionState curState = (IContributionService.EditionState)cmsCtx.getRequest().getAttribute("osivia.editionState");
        if (curState != null && curState.getBackPageMarker() != null) {
            boolean refresh = false;
            if (curState.isHasBeenModified()) {
                refresh = true;
            }
            String backUrl = this.urlFactory.getBackUrl(portalControllerContext, refresh);
            MenubarItem backItem = new MenubarItem("BACK", bundle.getString("BACK"), 40, backUrl, null, null, null);
            backItem.setGlyphicon("halflings arrow-left");
            backItem.setAjaxDisabled(true);
            backItem.setFirstItem(true);
            menubar.add(backItem);
        }
    }

    public CMSService getCmsService() {
        return this.cmsService;
    }

    public IPortalUrlFactory getUrlFactory() {
        return this.urlFactory;
    }

    public DefaultCMSCustomizer getCustomizer() {
        return this.customizer;
    }

    public IContributionService getContributionService() {
        return this.contributionService;
    }

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }
}

