/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationQueryCommand;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class WebConfigurationQueryCommand
implements INuxeoCommand {
    public static final String BASIC_NAVIGATION_SCHEMAS = "dublincore, common, toutatice, webconfiguration";
    private String domainPath;
    private WebConfigurationType type;

    public WebConfigurationQueryCommand(String domainPath, WebConfigurationType type) {
        this.domainPath = domainPath;
        this.type = type;
    }

    public Object execute(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.Query");
        String nuxeoRequest = "( ecm:path STARTSWITH '" + this.domainPath + "'  " + "AND  (wconf:type = '" + this.type.getTypeName() + "') AND (wconf:enabled=1) )";
        request.set("query", (Object)("SELECT * FROM Document WHERE " + nuxeoRequest + " ORDER BY wconf:order"));
        String navigationSchemas = BASIC_NAVIGATION_SCHEMAS;
        request.setHeader("X-NXDocumentProperties", navigationSchemas);
        return request.execute();
    }

    public String getId() {
        return "WebConfigurationQueryCommand/" + this.domainPath + "/" + this.type.toString();
    }
}

