/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.IFragmentModule;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.core.web.IWebIdService;

public class ZoomFragmentModule
implements IFragmentModule {
    public static final String ID = "zoom_property";
    public static final String DESC = "Zoom";
    public static final String JSP = "zoom";
    public static final String ADMIN_JSP = "zoom";
    private static final String REF_URI = "refURI";
    private static final String HREF = "href";
    private static final String CONTENT = "content";
    private static final String PICTURE = "picture";
    private static final String TEMPLATE = "zoomTemplate";
    private final IWebIdService webIdService = (IWebIdService)Locator.findMBean(IWebIdService.class, (String)"osivia:service=webIdService");

    public void injectViewAttributes(NuxeoController nuxeoController, PortalWindow window, PortletRequest request, RenderResponse response) throws Exception {
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        boolean emptyContent = true;
        if (StringUtils.isNotEmpty((String)nuxeoPath)) {
            PropertyList propertyList;
            Object content;
            String refURI;
            String schema;
            Document document = nuxeoController.fetchDocument(nuxeoPath = nuxeoController.getComputedPath(nuxeoPath));
            if (document.getTitle() != null) {
                response.setTitle(document.getTitle());
            }
            if (StringUtils.isNotEmpty((String)(schema = "zfgt:zoomFragment")) && StringUtils.isNotEmpty((String)(refURI = window.getProperty("osivia.refURI"))) && (content = document.getProperties().get(schema)) instanceof PropertyList && (propertyList = (PropertyList)content) != null && propertyList.size() > 0) {
                for (int index = 0; index < propertyList.size(); ++index) {
                    PropertyMap propertyMap = propertyList.getMap(index);
                    String refURIValue = (String)propertyMap.get(REF_URI);
                    if (!refURI.equalsIgnoreCase(refURIValue)) continue;
                    request.setAttribute("template", (Object)propertyMap.getString(TEMPLATE));
                    request.setAttribute("title", (Object)window.getProperty("osivia.title"));
                    String url = propertyMap.getString(HREF);
                    if (StringUtils.startsWith((String)url, (String)"/")) {
                        url = nuxeoController.getCMSLinkByPath(url, null).getUrl();
                    } else if (StringUtils.startsWith((String)url, (String)"http")) {
                        String urlServerName;
                        String serverName = nuxeoController.getRequest().getServerName();
                        request.setAttribute("external", (Object)(!StringUtils.equals((String)serverName, (String)(urlServerName = StringUtils.substringBefore((String)StringUtils.substringAfter((String)url, (String)"://"), (String)"/"))) ? 1 : 0));
                    } else if (StringUtils.isBlank((String)url)) {
                        url = "#";
                    } else {
                        String path = this.webIdService.webPathToPageUrl(url);
                        url = nuxeoController.getCMSLinkByPath(path, null).getUrl();
                    }
                    request.setAttribute("url", (Object)url);
                    String imageSource = null;
                    if (StringUtils.isNotBlank((String)propertyMap.getString(PICTURE))) {
                        imageSource = nuxeoController.createAttachedPictureLink(nuxeoPath, propertyMap.getString(PICTURE));
                    }
                    request.setAttribute("imageSource", imageSource);
                    request.setAttribute(CONTENT, (Object)nuxeoController.transformHTMLContent(StringUtils.trimToEmpty((String)propertyMap.getString(CONTENT))));
                    emptyContent = false;
                }
            }
        }
        if (emptyContent) {
            request.setAttribute("osivia.emptyResponse", (Object)"1");
        }
    }

    public void injectAdminAttributes(NuxeoController ctx, PortalWindow window, PortletRequest request, RenderResponse response) throws Exception {
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        request.setAttribute("nuxeoPath", (Object)StringUtils.trimToEmpty((String)nuxeoPath));
        String scope = window.getProperty("osivia.cms.forcePublicationScope");
        request.setAttribute("scope", (Object)scope);
    }

    public void processAdminAttributes(NuxeoController ctx, PortalWindow window, ActionRequest request, ActionResponse res) throws Exception {
        if (request.getParameter("nuxeoPath") != null) {
            window.setProperty("osivia.cms.uri", request.getParameter("nuxeoPath"));
        }
        if (request.getParameter("scope") != null && request.getParameter("scope").length() > 0) {
            window.setProperty("osivia.cms.forcePublicationScope", request.getParameter("scope"));
        } else if (window.getProperty("osivia.cms.forcePublicationScope") != null) {
            window.setProperty("osivia.cms.forcePublicationScope", null);
        }
    }
}

