/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.spi.StreamedSession;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.nuxeo.ecm.automation.client.model.StreamBlob;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class FileContentCommand
implements INuxeoCommand {
    Document document;
    String docPath;
    String fieldName;
    String timestamp;
    boolean streamingSupport = false;

    public FileContentCommand(Document document, String fieldName) {
        this.document = document;
        this.docPath = null;
        this.fieldName = fieldName;
    }

    public FileContentCommand(String docPath, String fieldName) {
        this.document = null;
        this.docPath = docPath;
        this.fieldName = fieldName;
    }

    public void setStreamingSupport(boolean streamingSupport) {
        this.streamingSupport = streamingSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session session) throws Exception {
        if (this.document == null) {
            this.document = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", "*").set("value", (Object)this.docPath).execute();
        }
        PropertyMap map = this.document.getProperties().getMap(this.fieldName);
        String pathFile = map.getString("data");
        if (this.streamingSupport) {
            StreamBlob blob = (StreamBlob)((StreamedSession)session).getStreamedFile(pathFile);
            CMSBinaryContent content = new CMSBinaryContent();
            String fileName = blob.getFileName();
            if (fileName == null || "null".equals(fileName)) {
                fileName = this.document.getTitle();
            }
            content.setName(fileName);
            content.setMimeType(blob.getMimeType());
            content.setStream(blob.getStream());
            content.setLongLiveSession((Object)session);
            return content;
        }
        FileBlob blob = (FileBlob)session.getFile(pathFile);
        FileInputStream in = new FileInputStream(blob.getFile());
        File tempFile = File.createTempFile("tempFile", ".tmp");
        tempFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tempFile);
        try {
            byte[] b = new byte[1000000];
            int i = -1;
            while ((i = ((InputStream)in).read(b)) != -1) {
                ((OutputStream)out).write(b, 0, i);
            }
            out.flush();
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        blob.getFile().delete();
        CMSBinaryContent content = new CMSBinaryContent();
        String fileName = blob.getFileName();
        if (fileName == null || "null".equals(fileName)) {
            fileName = this.document.getTitle();
        }
        content.setName(fileName);
        content.setFile(tempFile);
        content.setMimeType(blob.getMimeType());
        return content;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getId() {
        String id = "FileContentCommand";
        id = this.document == null ? id + this.docPath : id + this.document;
        if (this.timestamp != null) {
            id = id + this.timestamp;
        }
        id = id + "/" + this.fieldName;
        return id;
    }
}

