/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentAttachmentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.CommentDAO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.avatar.AvatarServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.AddCommentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.CreateChildCommentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.DeleteCommentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.GetCommentsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.site.SitePictureServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.thumbnail.ThumbnailServlet;
import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class ViewDocumentPortlet
extends CMSPortlet {
    private static final String PORTLET_MODE_ADMIN = "admin";
    private static final String PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    private static final String ONLY_DESCRIPTION_WINDOW_PROPERTY = "osivia.document.onlyDescription";
    private static final String METADATA_WINDOW_PROPERTY = "osivia.document.metadata";
    private static final String PATH_ADMIN = "/WEB-INF/jsp/document/admin.jsp";
    private static final String PATH_VIEW = "/WEB-INF/jsp/document/view.jsp";
    private INuxeoService nuxeoService;
    private DocumentDAO documentDAO;
    private CommentDAO commentDAO;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        try {
            this.nuxeoService = (INuxeoService)this.getPortletContext().getAttribute("NuxeoService");
            if (this.nuxeoService == null) {
                throw new PortletException("Cannot start ViewDocumentPortlet portlet due to service unavailability");
            }
            CMSCustomizer customizer = new CMSCustomizer(this.getPortletContext());
            this.nuxeoService.registerCMSCustomizer((INuxeoCustomizer)customizer);
            this.documentDAO = DocumentDAO.getInstance();
            this.commentDAO = CommentDAO.getInstance();
            CMSService cmsService = new CMSService(this.getPortletContext());
            ICMSServiceLocator cmsLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
            cmsLocator.register((ICMSService)cmsService);
            cmsService.setCustomizer((DefaultCMSCustomizer)customizer);
            customizer.setCmsService(cmsService);
            IDirectoryServiceLocator directoryServiceLocator = (IDirectoryServiceLocator)Locator.findMBean(IDirectoryServiceLocator.class, (String)"osivia:service=DirectoryServiceLocator");
            customizer.setDirectoryService(directoryServiceLocator.getDirectoryService());
            ThumbnailServlet.setPortletContext((PortletContext)this.getPortletContext());
            SitePictureServlet.setPortletContext((PortletContext)this.getPortletContext());
            AvatarServlet.setPortletContext((PortletContext)this.getPortletContext());
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = request.getParameter("javax.portlet.action");
        if (PORTLET_MODE_ADMIN.equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                String path = request.getParameter("path");
                window.setProperty(PATH_WINDOW_PROPERTY, path);
                String onlyDescription = request.getParameter("onlyDescription");
                window.setProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY, onlyDescription);
                String metadata = request.getParameter("metadata");
                window.setProperty(METADATA_WINDOW_PROPERTY, metadata);
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        } else if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            String id = request.getParameter("id");
            String content = request.getParameter("content");
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            String path = window.getProperty(PATH_WINDOW_PROPERTY);
            if (path != null) {
                Document document = nuxeoController.fetchDocument(path);
                if ("addComment".equals(action)) {
                    AddCommentCommand command = new AddCommentCommand(document, content, null, null);
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                } else if ("replyComment".equals(action)) {
                    CreateChildCommentCommand command = new CreateChildCommentCommand(document, id, content, null, null);
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                } else if ("deleteComment".equals(action)) {
                    DeleteCommentCommand command = new DeleteCommentCommand(document, id);
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                }
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(PATH_WINDOW_PROPERTY);
        request.setAttribute("path", (Object)path);
        boolean onlyDescription = BooleanUtils.toBoolean((String)window.getProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY));
        request.setAttribute("onlyDescription", (Object)onlyDescription);
        boolean metadata = BooleanUtils.toBoolean((String)window.getProperty(METADATA_WINDOW_PROPERTY));
        request.setAttribute("metadata", (Object)metadata);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_ADMIN).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            request.setAttribute("nuxeoController", (Object)nuxeoController);
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String path = window.getProperty(PATH_WINDOW_PROPERTY);
            path = nuxeoController.getComputedPath(path);
            if (StringUtils.isNotBlank((String)path)) {
                boolean maximized = WindowState.MAXIMIZED.equals((Object)request.getWindowState());
                boolean onlyDescription = BooleanUtils.toBoolean((String)window.getProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY));
                if (!maximized) {
                    request.setAttribute("onlyDescription", (Object)onlyDescription);
                }
                boolean metadata = BooleanUtils.toBoolean((String)window.getProperty(METADATA_WINDOW_PROPERTY));
                request.setAttribute("metadata", (Object)metadata);
                Document document = nuxeoController.fetchDocument(path);
                nuxeoController.setCurrentDoc(document);
                request.setAttribute("nuxeoDocument", (Object)document);
                DocumentDTO documentDTO = this.documentDAO.toDTO(document);
                request.setAttribute("document", (Object)documentDTO);
                String title = document.getTitle();
                if (StringUtils.isNotBlank((String)title)) {
                    response.setTitle(title);
                }
                if (!onlyDescription || maximized) {
                    ICMSService cmsService;
                    CMSPublicationInfos publicationInfos;
                    nuxeoController.insertContentMenuBarItems();
                    this.generateAttachments(nuxeoController, document, documentDTO);
                    if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && (publicationInfos = (cmsService = NuxeoController.getCMSService()).getPublicationInfos(cmsContext, path)).isCommentableByUser()) {
                        documentDTO.setCommentable(true);
                        this.generateComments(nuxeoController, document, documentDTO);
                    }
                }
            }
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(PATH_VIEW).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void generateAttachments(NuxeoController nuxeoController, Document document, DocumentDTO documentDTO) {
        List attachments = documentDTO.getAttachments();
        PropertyList files = document.getProperties().getList("files:files");
        if (files != null) {
            for (int i = 0; i < files.size(); ++i) {
                PropertyMap map = files.getMap(i);
                DocumentAttachmentDTO attachment = new DocumentAttachmentDTO();
                String name = map.getString("filename");
                attachment.setName(name);
                String url = nuxeoController.createAttachedFileLink(document.getPath(), String.valueOf(i));
                attachment.setUrl(url);
                attachments.add(attachment);
            }
        }
    }

    private void generateComments(NuxeoController nuxeoController, Document document, DocumentDTO documentDTO) {
        GetCommentsCommand getCommentsCommand = new GetCommentsCommand(document);
        JSONArray jsonComments = (JSONArray)nuxeoController.executeNuxeoCommand((INuxeoCommand)getCommentsCommand);
        for (int i = 0; i < jsonComments.size(); ++i) {
            JSONObject jsonComment = jsonComments.getJSONObject(i);
            CommentDTO commentDTO = this.commentDAO.toDTO(jsonComment);
            documentDTO.getComments().add(commentDTO);
        }
    }
}

