/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document.comments;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.HTMLCommentsTreeBuilder;
import java.io.File;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class CreateChildCommentCommand
implements INuxeoCommand {
    private Document document;
    private String commentId;
    private String childCommentContent;
    private String childCommentTitle;
    private File file;

    public CreateChildCommentCommand(Document document, String commentId, String childCommentContent, String childCommentTitle, File file) {
        this.document = document;
        this.commentId = commentId;
        this.childCommentContent = childCommentContent;
        this.childCommentTitle = childCommentTitle;
        this.file = file;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        boolean hasFile = this.file != null;
        OperationRequest request = nuxeoSession.newRequest("Document.CreateChildComment");
        request.set("commentableDoc", (Object)this.document.getId());
        request.set("comment", (Object)this.commentId);
        this.childCommentContent = HTMLCommentsTreeBuilder.storeNewLines((String)this.childCommentContent);
        request.set("childComment", (Object)this.childCommentContent);
        request.set("childCommentTitle", (Object)this.childCommentTitle);
        File tmpFile = null;
        if (hasFile) {
            request.set("fileName", (Object)this.file.getName());
            request.setInput((OperationInput)new FileBlob(this.file));
        } else {
            tmpFile = File.createTempFile("tmp_com", ".tmp");
            request.setInput((OperationInput)new FileBlob(tmpFile));
        }
        request.execute();
        tmpFile.delete();
        return this.document;
    }

    public String getId() {
        return "Document.CreateChildComment: " + this.document.getTitle();
    }
}

