/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.files;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.portlets.bridge.Formater;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserDocumentVO;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FolderGetFilesCommand;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSPublicationInfos;

public class FileBrowserPortlet
extends CMSPortlet {
    private static final String PATH_VIEW = "/WEB-INF/jsp/files/view.jsp";
    private IBundleFactory bundleFactory;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        IInternationalizationService internationalizationService = (IInternationalizationService)this.getPortletContext().getAttribute("InternationalizationService");
        if (internationalizationService == null) {
            throw new PortletException("Internationalization service initialization error.");
        }
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        try {
            Bundle bundle = this.bundleFactory.getBundle(resourceRequest.getLocale());
            if ("fileActions".equals(resourceRequest.getParameter("type"))) {
                NuxeoController ctx = new NuxeoController((PortletRequest)resourceRequest, null, this.getPortletContext());
                String id = resourceRequest.getResourceID();
                CMSPublicationInfos pubInfos = NuxeoController.getCMSService().getPublicationInfos(ctx.getCMSCtx(), id);
                StringBuffer sb = new StringBuffer();
                sb.append("<div>");
                int nbItems = 0;
                if (pubInfos.isEditableByUser()) {
                    Document doc = ctx.fetchDocument(id);
                    CMSItemType cmsItemType = (CMSItemType)ctx.getCMSItemTypes().get(doc.getType());
                    if (cmsItemType != null && cmsItemType.isSupportsPortalForms()) {
                        String refreshUrl = ctx.getPortalUrlFactory().getRefreshPageUrl(new PortalControllerContext(this.getPortletContext(), (PortletRequest)resourceRequest, (PortletResponse)resourceResponse));
                        String editLabel = bundle.getString("EDIT");
                        sb.append("<a class=\"fancyframe_refresh\" onClick=\"setCallbackParams(null, '").append(refreshUrl).append("')\" href=\"").append(ctx.getNuxeoPublicBaseUri()).append("/nxpath/default").append(pubInfos.getDocumentPath()).append("@toutatice_edit\">").append(editLabel).append("</a>");
                        ++nbItems;
                    }
                    if (nbItems > 0) {
                        sb.append("<br/>");
                    }
                    String manageLabel = bundle.getString("MANAGE");
                    sb.append("<a target=\"nuxeo\" href=\"").append(ctx.getNuxeoPublicBaseUri()).append("/nxdoc/default/").append(pubInfos.getLiveId()).append("/view_documents\">").append(manageLabel).append("</a>");
                    ++nbItems;
                }
                if (pubInfos.isDeletableByUser()) {
                    String deleteDivId = resourceResponse.getNamespace() + "delete-file-item";
                    String deleteFormId = resourceResponse.getNamespace() + "delete-file-form";
                    String deleteURL = ctx.getPortalUrlFactory().getPutDocumentInTrashUrl(new PortalControllerContext(this.getPortletContext(), (PortletRequest)resourceRequest, (PortletResponse)resourceResponse), pubInfos.getLiveId(), pubInfos.getDocumentPath());
                    String deleteLabel = bundle.getString("DELETE");
                    sb.append("<br/>");
                    sb.append("<a class=\"fancybox_inline\" href=\"#").append(deleteDivId).append("\" onclick=\"document.getElementById('").append(deleteFormId).append("').action ='").append(deleteURL).append("';\">").append(deleteLabel).append("</a>");
                    ++nbItems;
                }
                if (nbItems == 0) {
                    sb.append("<b>Aucune action<br/>disponible</b>");
                }
                sb.append("<div>");
                resourceResponse.getPortletOutputStream().write(sb.toString().getBytes());
                resourceResponse.getPortletOutputStream().close();
            } else {
                super.serveResource(resourceRequest, resourceResponse);
            }
        }
        catch (NuxeoException e) {
            this.serveResourceException(resourceRequest, resourceResponse, e);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        logger.debug((Object)"processAction ");
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("modifierPrefs") != null) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
            window.setProperty("osivia.nuxeoPath", req.getParameter("nuxeoPath"));
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("annuler") != null) {
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        NuxeoController ctx = new NuxeoController((PortletRequest)req, (PortletResponse)res, this.getPortletContext());
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String nuxeoPath = window.getProperty("osivia.nuxeoPath");
        if (nuxeoPath == null) {
            nuxeoPath = "";
        }
        req.setAttribute("nuxeoPath", (Object)nuxeoPath);
        req.setAttribute("ctx", (Object)ctx);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/files/admin.jsp");
        rd.include(req, res);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String path = window.getProperty("osivia.cms.uri");
            if (path == null) {
                path = window.getProperty("osivia.nuxeoPath");
            }
            if (StringUtils.isNotEmpty((String)path)) {
                NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                nuxeoController.setDisplayLiveVersion("1");
                path = nuxeoController.getComputedPath(path);
                Document doc = nuxeoController.fetchDocument(path);
                CMSPublicationInfos pubInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), path);
                Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new FolderGetFilesCommand(pubInfos.getDocumentPath(), pubInfos.getLiveId()));
                List sortedDocuments = documents.list();
                CMSItemType cmsItemType = (CMSItemType)nuxeoController.getCMSItemTypes().get(doc.getType());
                if (cmsItemType == null || !cmsItemType.isOrdered()) {
                    Collections.sort(sortedDocuments, new FileBrowserComparator(nuxeoController));
                }
                nuxeoController.setCurrentDoc(doc);
                nuxeoController.insertContentMenuBarItems();
                request.setAttribute("description", (Object)Formater.formatDescription((Document)doc));
                request.setAttribute("documents", (Object)this.toViewObjects(nuxeoController, sortedDocuments));
                request.setAttribute("path", (Object)path);
                response.setTitle(doc.getTitle());
            }
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(PATH_VIEW).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private Collection<FileBrowserDocumentVO> toViewObjects(NuxeoController nuxeoController, List<Document> documents) throws ParseException {
        ArrayList<FileBrowserDocumentVO> results = new ArrayList<FileBrowserDocumentVO>(documents.size());
        for (Document document : documents) {
            FileBrowserDocumentVO documentVO = new FileBrowserDocumentVO();
            documentVO.setTitle(document.getTitle());
            documentVO.setLink(nuxeoController.getLink(document, "fileExplorer"));
            documentVO.setSize(Formater.formatSize((Document)document));
            documentVO.setIconSource(Formater.formatNuxeoIcon((Document)document));
            documentVO.setIconAlt(document.getType());
            if ("File".equals(document.getType())) {
                documentVO.setDownloadLink(nuxeoController.getLink(document, "download"));
            }
            documentVO.setDate(Formater.formatDateAndTime((Document)document));
            documentVO.setLastContributor(StringUtils.trimToEmpty((String)document.getString("dc:lastContributor")));
            results.add(documentVO);
        }
        return results;
    }
}

