/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.publish;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.MenuComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.NavigationDisplayItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jboss.portal.common.invocation.InvocationContext;
import org.jboss.portal.core.controller.ControllerContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.osivia.portal.core.security.CmsPermissionHelper;

public class MenuPortlet
extends CMSPortlet {
    private static final String MAX_LEVELS_WINDOW_PROPERTY = "osivia.cms.maxLevels";
    private static final String START_LEVEL_WINDOW_PROPERTY = "osivia.cms.startLevel";
    private static final String OPEN_LEVELS_WINDOW_PROPERTY = "osivia.cms.openLevels";
    private static final String TEMPLATE_WINDOW_PROPERTY = "osivia.cms.template";
    private static final String FORCE_NAVIGATION_WINDOW_PROPERTY = "osivia.cms.forceNavigation";
    private static final int DEFAULT_MAX_LEVELS = 3;
    private static final int DEFAULT_START_LEVEL = 1;
    private static final int DEFAULT_OPEN_LEVELS = 1;
    private static final String PATH_VIEW_PREFIX = "/WEB-INF/jsp/publish/view";
    private static final String PATH_ADMIN = "/WEB-INF/jsp/publish/admin.jsp";
    private IPortalUrlFactory portalUrlFactory;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.portalUrlFactory = (IPortalUrlFactory)this.getPortletContext().getAttribute("UrlService");
        if (this.portalUrlFactory == null) {
            throw new PortletException("Cannot start TestPortlet due to service unavailability");
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        String action = request.getParameter("javax.portlet.action");
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                int openLevels = NumberUtils.toInt((String)request.getParameter("openLevels"));
                if (openLevels > 0) {
                    window.setProperty(OPEN_LEVELS_WINDOW_PROPERTY, String.valueOf(openLevels));
                } else {
                    window.setProperty(OPEN_LEVELS_WINDOW_PROPERTY, null);
                }
                int startLevel = NumberUtils.toInt((String)request.getParameter("startLevel"));
                if (startLevel > 0) {
                    window.setProperty(START_LEVEL_WINDOW_PROPERTY, String.valueOf(startLevel));
                } else {
                    window.setProperty(START_LEVEL_WINDOW_PROPERTY, null);
                }
                int maxLevels = NumberUtils.toInt((String)request.getParameter("maxLevels"));
                if (maxLevels > 0) {
                    window.setProperty(MAX_LEVELS_WINDOW_PROPERTY, String.valueOf(maxLevels));
                } else {
                    window.setProperty(MAX_LEVELS_WINDOW_PROPERTY, null);
                }
                String template = request.getParameter("template");
                window.setProperty(TEMPLATE_WINDOW_PROPERTY, template);
                String forceNavigation = request.getParameter("forceNavigation");
                window.setProperty(FORCE_NAVIGATION_WINDOW_PROPERTY, forceNavigation);
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String openLevels = window.getProperty(OPEN_LEVELS_WINDOW_PROPERTY);
        request.setAttribute("openLevels", (Object)openLevels);
        request.setAttribute("defaultOpenLevels", (Object)1);
        String startLevel = window.getProperty(START_LEVEL_WINDOW_PROPERTY);
        request.setAttribute("startLevel", (Object)startLevel);
        String maxLevels = window.getProperty(MAX_LEVELS_WINDOW_PROPERTY);
        request.setAttribute("maxLevels", (Object)maxLevels);
        request.setAttribute("defaultMaxLevels", (Object)3);
        SortedMap templates = NuxeoController.getCMSService().getMenuTemplates(request.getLocale());
        request.setAttribute("templates", (Object)templates);
        String selectedTemplate = window.getProperty(TEMPLATE_WINDOW_PROPERTY);
        request.setAttribute("selectedTemplate", (Object)selectedTemplate);
        boolean forceNavigation = BooleanUtils.toBoolean((String)window.getProperty(FORCE_NAVIGATION_WINDOW_PROPERTY));
        request.setAttribute("forceNavigation", (Object)forceNavigation);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_ADMIN).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            String menuRootPath;
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            String basePath = nuxeoController.getBasePath();
            String spacePath = nuxeoController.getSpacePath();
            boolean forceNavigation = BooleanUtils.toBoolean((String)window.getProperty(FORCE_NAVIGATION_WINDOW_PROPERTY));
            if (!forceNavigation && (menuRootPath = nuxeoController.getMenuRootPath()) != null) {
                basePath = menuRootPath;
                spacePath = menuRootPath;
            }
            int maxLevels = 3;
            String maxLevelWindowProperty = window.getProperty(MAX_LEVELS_WINDOW_PROPERTY);
            if (StringUtils.isNotBlank((String)maxLevelWindowProperty)) {
                maxLevels = NumberUtils.toInt((String)maxLevelWindowProperty);
            }
            int startLevel = 1;
            String startLevelWindowProperty = window.getProperty(START_LEVEL_WINDOW_PROPERTY);
            if (StringUtils.isNotBlank((String)startLevelWindowProperty)) {
                startLevel = NumberUtils.toInt((String)startLevelWindowProperty);
            }
            int openLevels = 1;
            String openLevelsWindowProperty = window.getProperty(OPEN_LEVELS_WINDOW_PROPERTY);
            if (StringUtils.isNotBlank((String)openLevelsWindowProperty)) {
                openLevels = NumberUtils.toInt((String)openLevelsWindowProperty);
            }
            String template = window.getProperty(TEMPLATE_WINDOW_PROPERTY);
            if (basePath != null) {
                NavigationDisplayItem displayItem;
                CMSServiceCtx cmsReadNavContext = new CMSServiceCtx();
                ControllerContext controllerContext = ControllerContextAdapter.getControllerContext((PortalControllerContext)nuxeoController.getPortalCtx());
                cmsReadNavContext.setControllerContext(controllerContext);
                cmsReadNavContext.setScope(nuxeoController.getNavigationScope());
                if (CmsPermissionHelper.getCurrentCmsVersion((InvocationContext)controllerContext).equals("preview")) {
                    cmsReadNavContext.setDisplayLiveVersion("1");
                }
                int partialOpenLevels = -1;
                CMSItem navItem = NuxeoController.getCMSService().getPortalNavigationItem(cmsReadNavContext, basePath, basePath);
                if ("1".equals(navItem.getProperties().get("partialLoading"))) {
                    partialOpenLevels = openLevels;
                }
                if ((displayItem = this.getDisplayItem(nuxeoController, cmsReadNavContext, 0, maxLevels, startLevel, spacePath, basePath, basePath, true, partialOpenLevels)) != null) {
                    if (displayItem.getTitle() != null) {
                        response.setTitle(displayItem.getTitle());
                    }
                    request.setAttribute("displayItem", (Object)displayItem);
                }
                request.setAttribute("startLevel", (Object)startLevel);
                request.setAttribute("openLevels", (Object)openLevels);
            }
            response.setContentType("text/html");
            String requestDispatcherPath = StringUtils.isEmpty((String)template) ? "/WEB-INF/jsp/publish/view.jsp" : "/WEB-INF/jsp/publish/view-" + template + ".jsp";
            this.getPortletContext().getRequestDispatcher(requestDispatcherPath).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private NavigationDisplayItem getDisplayItem(NuxeoController nuxeoController, CMSServiceCtx cmsContext, int level, int maxLevel, int startLevel, String spacePath, String basePath, String nuxeoPath, boolean isParentNavigable, int partialOpenLevels) throws CMSException {
        NavigationDisplayItem displayItem;
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSItem navItem = cmsService.getPortalNavigationItem(cmsContext, spacePath, nuxeoPath);
        if (navItem == null) {
            return null;
        }
        Document doc = (Document)navItem.getNativeItem();
        Link link = nuxeoController.getLink(doc, "menu");
        String navPath = navItem.getPath();
        String itemPath = nuxeoController.getItemNavigationPath();
        boolean selected = false;
        boolean current = false;
        if (itemPath != null) {
            if (itemPath.startsWith(navPath) && isParentNavigable) {
                selected = true;
                if (itemPath.equals(navPath)) {
                    current = true;
                }
            } else if (nuxeoController.getItemNavigationPath().equals(doc.getPath())) {
                selected = true;
                current = true;
            }
        }
        if (level + 1 >= startLevel) {
            displayItem = new NavigationDisplayItem(doc.getTitle(), link.getUrl(), link.isExternal(), selected, current, navItem);
            List displayChildren = this.getDisplayItemChildren(nuxeoController, cmsContext, level, maxLevel, startLevel, spacePath, basePath, nuxeoPath, partialOpenLevels, navItem, doc, selected);
            displayItem.getChildren().addAll(displayChildren);
        } else if (selected) {
            displayItem = null;
            List displayItemChildren = this.getDisplayItemChildren(nuxeoController, cmsContext, level, maxLevel, startLevel, spacePath, basePath, nuxeoPath, partialOpenLevels, navItem, doc, selected);
            for (NavigationDisplayItem displayItemChild : displayItemChildren) {
                if (!displayItemChild.isSelected()) continue;
                displayItem = displayItemChild;
                break;
            }
            if (displayItem == null && level == 0) {
                displayItem = new NavigationDisplayItem(doc.getTitle(), link.getUrl(), link.isExternal(), selected, current, navItem);
            }
        } else {
            displayItem = null;
        }
        return displayItem;
    }

    private List<NavigationDisplayItem> getDisplayItemChildren(NuxeoController nuxeoController, CMSServiceCtx cmsContext, int level, int maxLevel, int startLevel, String spacePath, String basePath, String nuxeoPath, int partialOpenLevels, CMSItem navItem, Document doc, boolean selected) throws CMSException {
        CMSItemType cmsItemType;
        ArrayList<NavigationDisplayItem> displayChildren;
        boolean partialOpened;
        ICMSService cmsService = NuxeoController.getCMSService();
        boolean partial = partialOpenLevels != -1;
        boolean fullOpened = !partial && level < maxLevel;
        boolean bl = partialOpened = partial && (selected || level + 1 <= partialOpenLevels);
        if (fullOpened || partialOpened) {
            List navItems = cmsService.getPortalNavigationSubitems(cmsContext, basePath, nuxeoPath);
            displayChildren = new ArrayList(navItems.size());
            for (CMSItem child : navItems) {
                NavigationDisplayItem newItem;
                if (!"1".equals(child.getProperties().get("menuItem")) || (newItem = this.getDisplayItem(nuxeoController, cmsContext, level + 1, maxLevel, startLevel, spacePath, basePath, child.getPath(), "1".equals(navItem.getProperties().get("navigationElement")), partialOpenLevels)) == null) continue;
                displayChildren.add(newItem);
            }
        } else {
            displayChildren = new ArrayList<NavigationDisplayItem>(0);
        }
        if ((cmsItemType = (CMSItemType)nuxeoController.getCMSItemTypes().get(doc.getType())) == null || !cmsItemType.isOrdered()) {
            Collections.sort(displayChildren, new MenuComparator(nuxeoController));
        }
        return displayChildren;
    }
}

