/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.selectors;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class KeywordsSelectorPortlet
extends CMSPortlet {
    private static final Log logger = LogFactory.getLog(KeywordsSelectorPortlet.class);
    public static final String DELETE_PREFIX = "delete_";

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        logger.debug((Object)"processAction ");
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = request.getParameter("javax.portlet.action");
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                List keywords;
                String identifier = request.getParameter("selectorId");
                if (StringUtils.isNotBlank((String)identifier)) {
                    window.setProperty("osivia.selectorId", identifier);
                } else {
                    window.setProperty("osivia.selectorId", null);
                }
                String label = request.getParameter("libelle");
                if (StringUtils.isNotBlank((String)label)) {
                    window.setProperty("osivia.libelle", label);
                } else {
                    window.setProperty("osivia.libelle", null);
                }
                if ("1".equals(request.getParameter("keywordMonoValued"))) {
                    window.setProperty("osivia.keywordMonoValued", "1");
                } else {
                    window.setProperty("osivia.keywordMonoValued", null);
                }
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                if (selectors != null && (keywords = (List)selectors.get(request.getParameter("selectorId"))) != null && keywords.size() > 0) {
                    keywords.clear();
                    selectors.put("selectorChanged", Arrays.asList("true"));
                    response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
                }
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        } else if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            boolean clear;
            boolean bl = clear = request.getParameter("clear") != null;
            if (request.getParameter("add") != null || request.getParameter("monoAdd") != null || clear) {
                String selectorId = window.getProperty("osivia.selectorId");
                if (selectorId != null) {
                    Map selectors;
                    ArrayList<String> keywords;
                    String keyword = null;
                    if (!clear) {
                        keyword = request.getParameter("keyword");
                    }
                    if ((keywords = (ArrayList<String>)(selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"))).get(selectorId)) == null) {
                        keywords = new ArrayList<String>();
                        selectors.put(selectorId, keywords);
                    }
                    if ("1".equals(window.getProperty("osivia.keywordMonoValued"))) {
                        keywords.clear();
                    }
                    if (StringUtils.isNotBlank((String)keyword)) {
                        keywords.add(keyword);
                    }
                    selectors.put("selectorChanged", Arrays.asList("true"));
                    response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
                    request.setAttribute("osivia.unsetMaxMode", (Object)"true");
                }
                response.setPortletMode(PortletMode.VIEW);
                response.setWindowState(WindowState.NORMAL);
            } else if ("delete".equals(request.getParameter("action"))) {
                String selectorId;
                int occ = new Integer(request.getParameter("occ")) - 1;
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                List keywords = (List)selectors.get(selectorId = window.getProperty("osivia.selectorId"));
                if (keywords != null && keywords.size() > occ) {
                    keywords.remove(occ);
                    selectors.put("selectorChanged", Arrays.asList("true"));
                    response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
                    request.setAttribute("osivia.unsetMaxMode", (Object)"true");
                }
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String selectorId = window.getProperty("osivia.selectorId");
        if (selectorId == null) {
            selectorId = "";
        }
        req.setAttribute("selectorId", (Object)selectorId);
        String libelle = window.getProperty("osivia.libelle");
        if (libelle == null) {
            libelle = "";
        }
        req.setAttribute("libelle", (Object)libelle);
        String keywordMonoValued = window.getProperty("osivia.keywordMonoValued");
        if (keywordMonoValued == null) {
            keywordMonoValued = "0";
        }
        req.setAttribute("keywordMonoValued", (Object)keywordMonoValued);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/selectors/keywords/admin.jsp");
        rd.include(req, res);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        logger.debug((Object)"doView");
        try {
            response.setContentType("text/html");
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String selectorId = window.getProperty("osivia.selectorId");
            String libelle = window.getProperty("osivia.libelle");
            request.setAttribute("libelle", (Object)libelle);
            String keywordMonoValued = window.getProperty("osivia.keywordMonoValued");
            request.setAttribute("keywordMonoValued", (Object)keywordMonoValued);
            String keyword = request.getParameter("keyword");
            if (selectorId != null) {
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                List selector = (List)selectors.get(selectorId);
                if (selector != null) {
                    String[] keywords = new String[selector.size()];
                    request.setAttribute("keywords", (Object)selector.toArray(keywords));
                } else {
                    request.setAttribute("keywords", (Object)ArrayUtils.EMPTY_STRING_ARRAY);
                }
                request.setAttribute("keyword", (Object)keyword);
                this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/selectors/keywords/view.jsp").include(request, response);
            } else {
                response.getWriter().print("<h2>Identifiant non d\u00e9fini</h2>");
                response.getWriter().close();
            }
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        logger.debug((Object)"doView end");
    }
}

