/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.util.ArrayList;
import java.util.HashMap;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.NavigationItem;

/*
 * Exception performing whole class analysis ignored.
 */
public class DocumentPublishSpaceNavigationCommand
implements INuxeoCommand {
    CMSItem publishSpaceConfig;
    private boolean forceLiveVersion;
    public static final String basicNavigationSchemas = "dublincore,common, toutatice, regions";

    public DocumentPublishSpaceNavigationCommand(CMSItem publishSpaceConfig, boolean forceLiveVersion) {
        this.publishSpaceConfig = publishSpaceConfig;
        this.forceLiveVersion = forceLiveVersion;
    }

    public static String computeNavPath(String path) {
        String result = path;
        if (path.endsWith(".proxy")) {
            result = result.substring(0, result.length() - 6);
        }
        return result;
    }

    public Object execute(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.Query");
        boolean live = "1".equals(this.publishSpaceConfig.getProperties().get("displayLiveVersion"));
        if (this.forceLiveVersion) {
            live = true;
        }
        String uuid = ((Document)this.publishSpaceConfig.getNativeItem()).getId();
        String path = this.publishSpaceConfig.getPath();
        String nuxeoRequest = "( ecm:path STARTSWITH '" + path + "'  AND  (ecm:mixinType = 'Folderish' OR ttc:showInMenu = 1)  )";
        NuxeoQueryFilterContext queryFilter = new NuxeoQueryFilterContext(live ? 1 : 0, "none");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)queryFilter, (String)nuxeoRequest);
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest + " ORDER BY ecm:pos"));
        String navigationSchemas = "dublincore,common, toutatice, regions";
        String extraNavigationSchemas = System.getProperty("nuxeo.navigationSchemas");
        if (extraNavigationSchemas != null) {
            navigationSchemas = navigationSchemas + ", " + extraNavigationSchemas;
        }
        request.setHeader("X-NXDocumentProperties", navigationSchemas);
        HashMap<String, NavigationItem> navItems = new HashMap<String, NavigationItem>();
        Documents children = (Documents)request.execute();
        ArrayList<Document> concatDocuments = new ArrayList<Document>();
        Document doc = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", navigationSchemas).set("value", (Object)uuid).execute();
        concatDocuments.add(doc);
        for (Document child : children) {
            concatDocuments.add(child);
        }
        for (Document child : concatDocuments) {
            String navPath = DocumentPublishSpaceNavigationCommand.computeNavPath((String)child.getPath());
            NavigationItem navItem = (NavigationItem)navItems.get(navPath);
            if (navItem == null) {
                navItem = new NavigationItem();
                navItems.put(navPath, navItem);
            }
            navItem.setMainDoc((Object)child);
            String parentPath = navPath.substring(0, navPath.lastIndexOf(47));
            if (!parentPath.contains(path)) continue;
            navItem = (NavigationItem)navItems.get(parentPath);
            if (navItem == null) {
                navItem = new NavigationItem();
                navItems.put(parentPath, navItem);
            }
            navItem.getChildren().add(child);
        }
        return navItems;
    }

    public String getId() {
        String sLive = "false";
        if (this.forceLiveVersion) {
            sLive = "true";
        }
        return "PublishSpaceNavigationCommandT2/" + sLive + "/" + this.publishSpaceConfig.getPath();
    }
}

