/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class ListCMSSubitemsCommand
implements INuxeoCommand {
    private final String parentId;
    private final boolean liveContent;
    private CMSServiceCtx cmsContext;

    public ListCMSSubitemsCommand(CMSServiceCtx cmsContext, String parentId, boolean liveContent) {
        this.cmsContext = cmsContext;
        this.parentId = parentId;
        this.liveContent = liveContent;
    }

    public List<CMSItem> execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Fetch.PublishingStatusChildren");
        request.set("documentId", (Object)this.parentId);
        request.set("liveStatus", (Object)this.liveContent);
        request.setHeader("X-NXDocumentProperties", this.getSchemas());
        Blob binariesPublishingInfos = (Blob)request.execute();
        String publishingInfos = IOUtils.toString((InputStream)binariesPublishingInfos.getStream(), (String)"UTF-8");
        return this.convertPublishingInfos(JSONArray.fromObject((Object)publishingInfos));
    }

    private List<CMSItem> convertPublishingInfos(JSONArray publishingInfos) throws CMSException, UnsupportedEncodingException {
        ArrayList<CMSItem> cmsItems = new ArrayList<CMSItem>(publishingInfos.size());
        for (JSONObject documentWithPublishingStatus : publishingInfos) {
            String documentId = (String)documentWithPublishingStatus.get("docId");
            String documentPath = URLDecoder.decode((String)documentWithPublishingStatus.get("docPath"), "UTF-8");
            String documentType = (String)documentWithPublishingStatus.get("docType");
            String documentTitle = URLDecoder.decode((String)documentWithPublishingStatus.get("docTitle"), "UTF-8");
            PropertyMap nxProperties = new PropertyMap();
            nxProperties.set("dc:title", documentTitle);
            Document poorDocument = new Document(documentId, documentType, null, null, documentPath, null, null, null, null, null, nxProperties, null);
            CMSService cmsService = (CMSService)NuxeoController.getCMSService();
            CMSItem cmsItem = cmsService.createItem(this.cmsContext, poorDocument.getPath(), poorDocument.getTitle(), poorDocument);
            boolean isPublished = documentWithPublishingStatus.getBoolean("isPublished");
            boolean isLiveModifiedFromProxy = documentWithPublishingStatus.getBoolean("isLiveModifiedFromProxy");
            cmsItem.setPublished(Boolean.valueOf(isPublished));
            cmsItem.setBeingModified(Boolean.valueOf(isLiveModifiedFromProxy));
            boolean isFolderish = documentWithPublishingStatus.getBoolean("isFolderish");
            CMSItemType cmsItemType = new CMSItemType(documentType, isFolderish, false, false, false, false, null, null);
            cmsItem.setType(cmsItemType);
            cmsItems.add(cmsItem);
        }
        return cmsItems;
    }

    public String getId() {
        StringBuilder id = new StringBuilder();
        id.append(this.getClass().getCanonicalName());
        id.append("[");
        id.append(this.parentId);
        id.append(";");
        id.append(this.liveContent);
        id.append("]");
        return id.toString();
    }

    private String getSchemas() {
        return "dublincore, common, toutatice";
    }
}

