/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.tags;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;

public class FormatFileSizeTag
extends SimpleTagSupport {
    private static final String[] UNITS = new String[]{"BYTE", "KILOBYTE", "MEGABYTE", "GIGABYTE", "TERABYTE"};
    private static final double UNIT_FACTOR = 1024.0;
    private static final IBundleFactory BUNDLE_FACTORY = FormatFileSizeTag.getBundleFactory();
    private Long size;

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest request = pageContext.getRequest();
        Locale locale = request.getLocale();
        Bundle bundle = BUNDLE_FACTORY.getBundle(locale);
        int factor = Double.valueOf(Math.log10(this.size.longValue()) / Math.log10(1024.0)).intValue();
        double factorizedSize = (double)this.size.longValue() / Math.pow(1024.0, factor);
        String unit = bundle.getString(UNITS[factor]);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setMaximumFractionDigits(1);
        JspWriter out = pageContext.getOut();
        out.write(numberFormat.format(factorizedSize));
        out.write(" ");
        out.write(unit);
    }

    private static IBundleFactory getBundleFactory() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        return internationalizationService.getBundleFactory(FormatFileSizeTag.class.getClassLoader());
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }
}

