/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.tags;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.urls.Link;

public class GetDocumentURLTag
extends SimpleTagSupport {
    private String displayContext;
    private Boolean picture;

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest request = pageContext.getRequest();
        NuxeoController nuxeoController = (NuxeoController)request.getAttribute("nuxeoController");
        Document document = (Document)request.getAttribute("nuxeoDocument");
        if (nuxeoController != null && document != null) {
            String url;
            if (BooleanUtils.isTrue((Boolean)this.picture)) {
                String path = document.getPath();
                url = nuxeoController.createPictureLink(path, StringUtils.defaultIfEmpty((String)this.displayContext, (String)"Original"));
            } else {
                Link link = nuxeoController.getLink(document, StringUtils.trimToNull((String)this.displayContext));
                url = link.getUrl();
            }
            JspWriter out = pageContext.getOut();
            out.write(url);
        }
    }

    public String getDisplayContext() {
        return this.displayContext;
    }

    public void setDisplayContext(String displayContext) {
        this.displayContext = displayContext;
    }

    public Boolean getPicture() {
        return this.picture;
    }

    public void setPicture(Boolean picture) {
        this.picture = picture;
    }
}

